/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.dsl.schema.meta;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.dsl.schema.ValidationErrorMessage;
import fr.gouv.vitam.common.dsl.schema.meta.Format;
import fr.gouv.vitam.common.dsl.schema.meta.Schema;
import fr.gouv.vitam.common.dsl.schema.meta.ValidatorEngine;
import java.util.Map;
import java.util.function.Consumer;

public class ObjectFormat
extends Format {
    private Map<String, Format> elements;

    @Override
    protected void resolve(Schema schema) {
        for (Map.Entry<String, Format> entry : this.elements.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
    }

    public void setElements(Map<String, Format> elements) {
        this.elements = elements;
    }

    @Override
    public void validate(JsonNode node, Consumer<String> fieldReport, ValidatorEngine validator) {
        if (!node.isObject()) {
            validator.reportError(this, node, ValidationErrorMessage.Code.WRONG_JSON_TYPE, node.getNodeType().name());
            return;
        }
        for (Map.Entry<String, Format> entry : this.elements.entrySet()) {
            String name = entry.getKey();
            Format subProperty = entry.getValue();
            validator.pushContext(name);
            JsonNode value = node.get(name);
            if (value == null) {
                if (!subProperty.isOptional()) {
                    validator.reportError(subProperty, node, ValidationErrorMessage.Code.MANDATORY, null);
                }
            } else {
                fieldReport.accept(name);
                validator.validate(subProperty, value, null);
            }
            validator.popContext();
        }
    }

    @Override
    public void walk(Consumer<Format> consumer) {
        consumer.accept(this);
        for (Format property : this.elements.values()) {
            property.walk(consumer);
        }
    }

    @Override
    public String debugInfo() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        boolean notFirst = false;
        for (Map.Entry<String, Format> entry : this.elements.entrySet()) {
            if (notFirst) {
                builder.append(", ");
            }
            builder.append(entry.getKey());
            builder.append(": ...");
            notFirst = true;
        }
        builder.append("}");
        return builder.toString();
    }
}

