/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.dsl.schema.meta;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.dsl.schema.ValidationErrorMessage;
import fr.gouv.vitam.common.dsl.schema.meta.Format;
import fr.gouv.vitam.common.dsl.schema.meta.Schema;
import fr.gouv.vitam.common.dsl.schema.meta.ValidatorEngine;
import java.util.function.Consumer;

public class ArrayFormat
extends Format {
    private Format itemType;

    @Override
    protected void resolve(Schema schema) {
        this.itemType.setReportingType(this);
    }

    public void setItemtype(Format itemType) {
        this.itemType = itemType;
    }

    @Override
    public void validate(JsonNode node, Consumer<String> fieldReport, ValidatorEngine validator) {
        if (!node.isArray()) {
            validator.reportError(this, node, ValidationErrorMessage.Code.WRONG_JSON_TYPE, node.getNodeType().name());
            return;
        }
        for (JsonNode item : node) {
            validator.validate(this.itemType, item, null);
        }
    }

    @Override
    public void walk(Consumer<Format> consumer) {
        consumer.accept(this);
        this.itemType.walk(consumer);
    }

    @Override
    public String debugInfo() {
        return this.itemType.debugInfo() + "[]";
    }
}

