/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.workspace.client;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.VitamClientFactory;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.client.configuration.ClientConfigurationImpl;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import java.net.URI;

public class WorkspaceClientFactory
extends VitamClientFactory<WorkspaceClient> {
    private static final WorkspaceClientFactory WORKSPACE_CLIENT_FACTORY = new WorkspaceClientFactory("/workspace/v1");
    private static final WorkspaceClientFactory WORKSPACE_COLLECT_CLIENT_FACTORY = new WorkspaceClientFactory("/workspace-collect/v1");

    private WorkspaceClientFactory(String resourcePath) {
        super(null, resourcePath);
    }

    public static WorkspaceClientFactory getInstance(WorkspaceType workspaceType) {
        if (workspaceType == WorkspaceType.VITAM) {
            return WORKSPACE_CLIENT_FACTORY;
        }
        if (workspaceType == WorkspaceType.COLLECT) {
            return WORKSPACE_COLLECT_CLIENT_FACTORY;
        }
        throw new IllegalArgumentException("Unknown " + String.valueOf((Object)workspaceType));
    }

    public WorkspaceClient getClient() {
        return new WorkspaceClient(this);
    }

    public static void changeMode(String serviceUrl, WorkspaceType workspaceType) {
        ParametersChecker.checkParameter((String)"Server Url can not be null", (String[])new String[]{serviceUrl});
        URI uri = URI.create(serviceUrl);
        ClientConfigurationImpl configuration = new ClientConfigurationImpl(uri.getHost(), uri.getPort());
        WorkspaceClientFactory.changeMode((ClientConfiguration)configuration, workspaceType);
    }

    private static void changeMode(ClientConfiguration configuration, WorkspaceType workspaceType) {
        WorkspaceClientFactory.getInstance(workspaceType).initialisation(configuration, WorkspaceClientFactory.getInstance(workspaceType).getResourcePath());
    }
}

