/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.common.model.request;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import java.io.File;

public class ObjectDescription {
    private String workspaceContainerGUID;
    private String workspaceObjectURI;
    private String objectName;
    private DataCategory type;

    public ObjectDescription() {
    }

    public ObjectDescription(DataCategory type, String workspaceContainerGUID, String objectName, String workspaceObjectUri) {
        this.type = type;
        this.workspaceContainerGUID = workspaceContainerGUID;
        this.objectName = objectName;
        this.workspaceObjectURI = workspaceObjectUri;
    }

    public String getWorkspaceObjectURI() {
        if (ParametersChecker.isNotEmpty((String[])new String[]{this.workspaceObjectURI}) || this.type == null) {
            return this.workspaceObjectURI;
        }
        return this.type.getCollectionName() + File.separator + this.objectName;
    }

    public ObjectDescription setWorkspaceObjectURI(String workspaceObjectURI) {
        this.workspaceObjectURI = workspaceObjectURI;
        return this;
    }

    public String getWorkspaceContainerGUID() {
        return this.workspaceContainerGUID;
    }

    public ObjectDescription setWorkspaceContainerGUID(String workspaceContainerGUID) {
        this.workspaceContainerGUID = workspaceContainerGUID;
        return this;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public ObjectDescription setObjectName(String objectName) {
        this.objectName = objectName;
        return this;
    }

    public DataCategory getType() {
        return this.type;
    }

    public ObjectDescription setType(DataCategory type) {
        this.type = type;
        return this;
    }
}

