/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.common.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import fr.gouv.vitam.storage.engine.common.model.OfferLog;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

public class CompactedOfferLog {
    public static final String SEQUENCE_START = "SequenceStart";
    public static final String SEQUENCE_END = "SequenceEnd";
    public static final String CONTAINER = "Container";
    public static final String LOGS = "Logs";
    @JsonProperty(value="SequenceStart")
    private long sequenceStart;
    @JsonProperty(value="SequenceEnd")
    private long sequenceEnd;
    @JsonProperty(value="CompactionDateTime")
    private LocalDateTime compactionDateTime;
    @JsonProperty(value="Container")
    private String container;
    @JsonProperty(value="Logs")
    private List<OfferLog> logs;

    public CompactedOfferLog() {
    }

    public CompactedOfferLog(long sequenceStart, long sequenceEnd, LocalDateTime compactionDateTime, String container, List<OfferLog> logs) {
        this.sequenceStart = sequenceStart;
        this.sequenceEnd = sequenceEnd;
        this.compactionDateTime = Objects.requireNonNull(compactionDateTime);
        this.container = Objects.requireNonNull(container);
        this.logs = Objects.requireNonNull(logs);
    }

    public long getSequenceStart() {
        return this.sequenceStart;
    }

    public void setSequenceStart(long sequenceStart) {
        this.sequenceStart = sequenceStart;
    }

    public long getSequenceEnd() {
        return this.sequenceEnd;
    }

    public void setSequenceEnd(long sequenceEnd) {
        this.sequenceEnd = sequenceEnd;
    }

    public LocalDateTime getCompactionDateTime() {
        return this.compactionDateTime;
    }

    public void setCompactionDateTime(LocalDateTime compactionDateTime) {
        this.compactionDateTime = compactionDateTime;
    }

    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public List<OfferLog> getLogs() {
        return this.logs;
    }

    public void setLogs(List<OfferLog> logs) {
        this.logs = logs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompactedOfferLog that = (CompactedOfferLog)o;
        return this.sequenceStart == that.sequenceStart && this.sequenceEnd == that.sequenceEnd && this.compactionDateTime.equals(that.compactionDateTime) && this.container.equals(that.container) && Objects.equals(this.logs, that.logs);
    }

    public int hashCode() {
        return Objects.hash(this.sequenceStart, this.sequenceEnd, this.compactionDateTime, this.container, this.logs);
    }

    public String toString() {
        return "OfferLogCompaction{sequenceStart=" + this.sequenceStart + ", sequenceEnd=" + this.sequenceEnd + ", compactionDateTime=" + String.valueOf(this.compactionDateTime) + ", container='" + this.container + "'}";
    }
}

