/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.temporal.ChronoUnit;
import java.util.Objects;

public class OfferLogCompactionConfiguration {
    private static final int MIN_COMPACTION_SIZE = 1000;
    private static final int MAX_COMPACTION_SIZE = 200000;
    private final long expirationValue;
    private final ChronoUnit expirationUnit;
    private final int compactionSize;

    @JsonCreator
    public OfferLogCompactionConfiguration(@JsonProperty(value="expirationValue") long expirationValue, @JsonProperty(value="expirationUnit") ChronoUnit expirationUnit, @JsonProperty(value="compactionSize") int compactionSize) {
        this.expirationValue = expirationValue;
        this.expirationUnit = expirationUnit;
        this.compactionSize = compactionSize;
    }

    public void validateConf() {
        if (this.expirationValue <= 0L) {
            throw new IllegalStateException("Invalid offer log compaction configuration. Negative expiration value " + this.expirationValue);
        }
        if (this.expirationUnit == null) {
            throw new IllegalStateException("Invalid offer log compaction configuration. Missing expiration unit");
        }
        if (this.compactionSize > 200000 || this.compactionSize < 1000) {
            throw new IllegalStateException("Invalid offer log compaction configuration. Invalid compaction size " + this.compactionSize + " expected between 1000 and 200000");
        }
    }

    public long getExpirationValue() {
        return this.expirationValue;
    }

    public ChronoUnit getExpirationUnit() {
        return this.expirationUnit;
    }

    public int getCompactionSize() {
        return this.compactionSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfferLogCompactionConfiguration that = (OfferLogCompactionConfiguration)o;
        return this.expirationValue == that.expirationValue && this.compactionSize == that.compactionSize && this.expirationUnit == that.expirationUnit;
    }

    public int hashCode() {
        return Objects.hash(this.expirationValue, this.expirationUnit, this.compactionSize);
    }

    public String toString() {
        return "OfferLogCompactionConfiguration{expirationValue=" + this.expirationValue + ", expirationUnit=" + String.valueOf(this.expirationUnit) + ", compactionSize=" + this.compactionSize + "}";
    }
}

