/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.rest;

import com.google.common.base.Strings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import fr.gouv.vitam.cas.container.builder.StoreContextBuilder;
import fr.gouv.vitam.common.FileUtil;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.server.application.configuration.DbConfiguration;
import fr.gouv.vitam.common.storage.StorageConfiguration;
import fr.gouv.vitam.common.storage.cas.container.api.ContentAddressableStorage;
import fr.gouv.vitam.storage.engine.common.collection.OfferCollections;
import fr.gouv.vitam.storage.offers.core.DefaultOfferService;
import fr.gouv.vitam.storage.offers.core.DefaultOfferServiceImpl;
import fr.gouv.vitam.storage.offers.core.SanityCheckOfferServiceDecorator;
import fr.gouv.vitam.storage.offers.database.OfferLogAndCompactedOfferLogService;
import fr.gouv.vitam.storage.offers.database.OfferLogCompactionDatabaseService;
import fr.gouv.vitam.storage.offers.database.OfferLogDatabaseService;
import fr.gouv.vitam.storage.offers.database.OfferSequenceDatabaseService;
import fr.gouv.vitam.storage.offers.rest.OfferConfiguration;
import java.io.File;
import java.io.InputStream;
import org.bson.Document;

public class OfferCommonApplication {
    private static final OfferCommonApplication instance = new OfferCommonApplication();
    private StorageConfiguration storageConfiguration;
    private DefaultOfferService defaultOfferService;
    private ContentAddressableStorage contentAddressableStorage;

    public static OfferCommonApplication getInstance() {
        return instance;
    }

    synchronized void initialize(String configurationFile) {
        try (InputStream yamlIS = PropertiesUtils.getConfigAsStream((String)configurationFile);){
            OfferConfiguration configuration = (OfferConfiguration)((Object)PropertiesUtils.readYaml((InputStream)yamlIS, OfferConfiguration.class));
            if (configuration.getOfferLogCompactionConfiguration() == null) {
                throw new IllegalStateException("Invalid configuration. Missing offer log compaction config");
            }
            configuration.getOfferLogCompactionConfiguration().validateConf();
            MongoClient mongoClient = MongoDbAccess.createMongoClient((DbConfiguration)configuration);
            MongoDatabase mongoDatabase = mongoClient.getDatabase(configuration.getDbName());
            OfferSequenceDatabaseService offerSequenceDatabaseService = new OfferSequenceDatabaseService((MongoCollection<Document>)mongoDatabase.getCollection(OfferCollections.OFFER_SEQUENCE.getName()));
            OfferLogDatabaseService offerDatabaseService = new OfferLogDatabaseService((MongoCollection<Document>)mongoDatabase.getCollection(OfferCollections.OFFER_LOG.getName()));
            OfferLogCompactionDatabaseService offerLogCompactionDatabaseService = new OfferLogCompactionDatabaseService((MongoCollection<Document>)mongoDatabase.getCollection(OfferCollections.COMPACTED_OFFER_LOG.getName()));
            OfferLogAndCompactedOfferLogService offerLogAndCompactedOfferLogService = new OfferLogAndCompactedOfferLogService((MongoCollection<Document>)mongoDatabase.getCollection(OfferCollections.OFFER_LOG.getName()), (MongoCollection<Document>)mongoDatabase.getCollection(OfferCollections.COMPACTED_OFFER_LOG.getName()));
            this.storageConfiguration = (StorageConfiguration)PropertiesUtils.readYaml((File)PropertiesUtils.findFile((String)"default-storage.conf"), StorageConfiguration.class);
            if (Strings.isNullOrEmpty((String)this.storageConfiguration.getStoragePath())) {
                this.storageConfiguration.setStoragePath(FileUtil.getFileCanonicalPath((String)configuration.getStoragePath()));
            } else {
                this.storageConfiguration.setStoragePath(FileUtil.getFileCanonicalPath((String)this.storageConfiguration.getStoragePath()));
            }
            this.contentAddressableStorage = StoreContextBuilder.newStoreContext((StorageConfiguration)this.storageConfiguration, (MongoDatabase)mongoDatabase);
            DefaultOfferServiceImpl defaultOfferServiceImpl = new DefaultOfferServiceImpl(this.contentAddressableStorage, offerLogCompactionDatabaseService, offerDatabaseService, offerSequenceDatabaseService, this.storageConfiguration, configuration.getOfferLogCompactionConfiguration(), offerLogAndCompactedOfferLogService, configuration.getMaxBatchThreadPoolSize(), configuration.getBatchMetadataComputationTimeout(), configuration.isCleanupObjectsOnWriteError());
            this.defaultOfferService = new SanityCheckOfferServiceDecorator(defaultOfferServiceImpl, this.storageConfiguration);
        }
        catch (Exception e) {
            throw new VitamRuntimeException((Throwable)e);
        }
    }

    DefaultOfferService getDefaultOfferService() {
        return this.defaultOfferService;
    }

    public ContentAddressableStorage getContentAddressableStorage() {
        return this.contentAddressableStorage;
    }

    StorageConfiguration getStorageConfiguration() {
        return this.storageConfiguration;
    }
}

