/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.core;

import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.model.storage.AccessRequestStatus;
import fr.gouv.vitam.common.security.IllegalPathException;
import fr.gouv.vitam.common.security.SafeFileChecker;
import fr.gouv.vitam.common.storage.ContainerInformation;
import fr.gouv.vitam.common.storage.StorageConfiguration;
import fr.gouv.vitam.common.storage.cas.container.api.ObjectContent;
import fr.gouv.vitam.common.storage.cas.container.api.ObjectListingListener;
import fr.gouv.vitam.common.storage.constants.StorageProvider;
import fr.gouv.vitam.common.stream.MultiplexedStreamReader;
import fr.gouv.vitam.storage.driver.model.StorageBulkMetadataResult;
import fr.gouv.vitam.storage.driver.model.StorageBulkPutResult;
import fr.gouv.vitam.storage.driver.model.StorageMetadataResult;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.OfferLog;
import fr.gouv.vitam.storage.engine.common.model.Order;
import fr.gouv.vitam.storage.offers.core.DefaultOfferService;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class SanityCheckOfferServiceDecorator
implements DefaultOfferService {
    private final DefaultOfferService innerService;
    private final String rootPath;

    public SanityCheckOfferServiceDecorator(DefaultOfferService innerService, StorageConfiguration configuration) {
        this.innerService = innerService;
        StorageProvider provider = StorageProvider.getStorageProvider((String)configuration.getProvider());
        this.rootPath = provider.hasStoragePath() ? configuration.getStoragePath() : VitamConfiguration.getVitamTmpFolder();
    }

    @Override
    public String getObjectDigest(String containerName, String objectId, DigestType digestAlgorithm) throws ContentAddressableStorageException {
        this.checkSafeObjectPath(containerName, objectId);
        return this.innerService.getObjectDigest(containerName, objectId, digestAlgorithm);
    }

    @Override
    public ObjectContent getObject(String containerName, String objectId) throws ContentAddressableStorageException {
        this.checkSafeObjectPath(containerName, objectId);
        return this.innerService.getObject(containerName, objectId);
    }

    @Override
    public String createAccessRequest(String containerName, List<String> objectIds) throws ContentAddressableStorageException {
        for (String objectId : objectIds) {
            this.checkSafeObjectPath(containerName, objectId);
        }
        return this.innerService.createAccessRequest(containerName, objectIds);
    }

    @Override
    public Map<String, AccessRequestStatus> checkAccessRequestStatuses(List<String> accessRequestIds, boolean adminCrossTenantAccessRequestAllowed) throws ContentAddressableStorageException {
        return this.innerService.checkAccessRequestStatuses(accessRequestIds, adminCrossTenantAccessRequestAllowed);
    }

    @Override
    public void removeAccessRequest(String accessRequestId, boolean adminCrossTenantAccessRequestAllowed) throws ContentAddressableStorageException {
        this.innerService.removeAccessRequest(accessRequestId, adminCrossTenantAccessRequestAllowed);
    }

    @Override
    public boolean checkObjectAvailability(String containerName, List<String> objectIds) throws ContentAddressableStorageException {
        for (String objectId : objectIds) {
            this.checkSafeObjectPath(containerName, objectId);
        }
        return this.innerService.checkObjectAvailability(containerName, objectIds);
    }

    @Override
    public String createObject(String containerName, String objectId, InputStream objectPart, DataCategory type, long size, DigestType digestType) throws ContentAddressableStorageException {
        this.checkSafeObjectPath(containerName, objectId);
        return this.innerService.createObject(containerName, objectId, objectPart, type, size, digestType);
    }

    @Override
    public StorageBulkPutResult bulkPutObjects(String containerName, List<String> objectIds, MultiplexedStreamReader multiplexedStreamReader, DataCategory type, DigestType digestType) throws ContentAddressableStorageException, IOException {
        for (String objectId : objectIds) {
            this.checkSafeObjectPath(containerName, objectId);
        }
        return this.innerService.bulkPutObjects(containerName, objectIds, multiplexedStreamReader, type, digestType);
    }

    @Override
    public boolean isObjectExist(String containerName, String objectId) throws ContentAddressableStorageException {
        this.checkSafeObjectPath(containerName, objectId);
        return this.innerService.isObjectExist(containerName, objectId);
    }

    @Override
    public ContainerInformation getCapacity(String containerName) throws ContentAddressableStorageException {
        this.checkSafeContainerPath(containerName);
        return this.innerService.getCapacity(containerName);
    }

    @Override
    public void deleteObject(String containerName, String objectId, DataCategory type) throws ContentAddressableStorageException {
        this.checkSafeObjectPath(containerName, objectId);
        this.innerService.deleteObject(containerName, objectId, type);
    }

    @Override
    public StorageMetadataResult getMetadata(String containerName, String objectId, boolean noCache) throws ContentAddressableStorageException {
        this.checkSafeObjectPath(containerName, objectId);
        return this.innerService.getMetadata(containerName, objectId, noCache);
    }

    @Override
    public List<OfferLog> getOfferLogs(String containerName, Long offset, int limit, Order order) throws ContentAddressableStorageException {
        this.checkSafeContainerPath(containerName);
        return this.innerService.getOfferLogs(containerName, offset, limit, order);
    }

    @Override
    public void listObjects(String containerName, ObjectListingListener objectListingListener) throws IOException, ContentAddressableStorageException {
        this.checkSafeContainerPath(containerName);
        this.innerService.listObjects(containerName, objectListingListener);
    }

    @Override
    public void compactOfferLogs() throws Exception {
        this.innerService.compactOfferLogs();
    }

    @Override
    public StorageBulkMetadataResult getBulkMetadata(String containerName, List<String> objectIds, Boolean noCache) throws ContentAddressableStorageException {
        for (String objectId : objectIds) {
            this.checkSafeObjectPath(containerName, objectId);
        }
        return this.innerService.getBulkMetadata(containerName, objectIds, noCache);
    }

    private void checkSafeObjectPath(String containerName, String objectId) throws ContentAddressableStorageException {
        try {
            SafeFileChecker.checkSafeFilePath((String)this.rootPath, (String[])new String[]{containerName, objectId});
        }
        catch (IllegalPathException e) {
            throw new ContentAddressableStorageException("Illegal object path " + containerName + "/" + objectId, (Throwable)e);
        }
    }

    private void checkSafeContainerPath(String containerName) throws ContentAddressableStorageException {
        try {
            SafeFileChecker.checkSafeFilePath((String)this.rootPath, (String[])new String[]{containerName});
        }
        catch (IllegalPathException e) {
            throw new ContentAddressableStorageException("Illegal container name " + containerName, (Throwable)e);
        }
    }
}

