/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.server.application.junit;

import com.google.common.base.Strings;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ResponseHelper {
    private ResponseHelper() {
    }

    public static Response getOutboundResponse(Response.Status status, Object entity, String contentType, Map<String, String> headers) {
        if (status == null) {
            throw new IllegalArgumentException("status cannot be null");
        }
        Response response = (Response)Mockito.mock(Response.class);
        Mockito.when((Object)response.getStatus()).thenReturn((Object)status.getStatusCode());
        if (entity == null) {
            Mockito.when((Object)response.readEntity((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)"");
        } else {
            Mockito.when((Object)response.readEntity((Class)ArgumentMatchers.any(Class.class))).thenReturn(entity);
        }
        boolean contentTypeFound = false;
        if (!Strings.isNullOrEmpty((String)contentType)) {
            Mockito.when((Object)response.getHeaderString("Content-Type")).thenReturn((Object)contentType);
            contentTypeFound = true;
        }
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                Mockito.when((Object)response.getHeaderString(entry.getKey())).thenReturn((Object)entry.getValue());
            }
        }
        if (!contentTypeFound) {
            Mockito.when((Object)response.getHeaderString("Content-Type")).thenReturn((Object)"application/json");
        }
        return response;
    }
}

