/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.management.client;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.DefaultClient;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.VitamRequestBuilder;
import fr.gouv.vitam.common.exception.AccessUnauthorizedException;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.ConflictClientException;
import fr.gouv.vitam.common.exception.ForbiddenClientException;
import fr.gouv.vitam.common.exception.InternalServerException;
import fr.gouv.vitam.common.exception.PreconditionFailedClientException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.exception.WorkflowNotFoundException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.ProcessAction;
import fr.gouv.vitam.common.model.ProcessPause;
import fr.gouv.vitam.common.model.ProcessQuery;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.processing.ProcessDetail;
import fr.gouv.vitam.common.model.processing.WorkFlow;
import fr.gouv.vitam.processing.common.ProcessingEntry;
import fr.gouv.vitam.processing.common.exception.ProcessingBadRequestException;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.model.WorkerBean;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClient;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import java.util.Optional;
import javax.ws.rs.core.Response;

class ProcessingManagementClientRest
extends DefaultClient
implements ProcessingManagementClient {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ProcessingManagementClientRest.class);
    private static final String ERR_CONTAINER_IS_MANDATORY = "Container is mandatory";
    private static final String ERR_WORKFLOW_IS_MANDATORY = "Workflow is mandatory";
    private static final String ILLEGAL_ARGUMENT = "Illegal Argument";
    private static final String NOT_FOUND = "Not Found";
    private static final String BAD_REQUEST_EXCEPTION = "Bad Request Exception";
    private static final String OPERATION_URI = "/operations";
    private static final String WORKFLOWS_URI = "/workflows";
    private static final String FORCE_PAUSE_URI = "/forcepause";
    private static final String REMOVE_FORCE_PAUSE_URI = "/removeforcepause";
    private static final String ACTION_ID_MUST_HAVE_A_VALID_VALUE = "Action id must have a valid value";
    private static final String BLANK_OPERATION_ID = "Operation identifier should be filled";

    ProcessingManagementClientRest(ProcessingManagementClientFactory factory) {
        super((VitamClientFactoryInterface)factory);
    }

    @Override
    public void initVitamProcess(String container, String workflowId) throws BadRequestException, InternalServerException {
        this.initVitamProcess(new ProcessingEntry(container, workflowId));
    }

    @Override
    public void initVitamProcess(ProcessingEntry entry) throws InternalServerException, BadRequestException {
        ParametersChecker.checkParameter((String)ERR_CONTAINER_IS_MANDATORY, (String[])new String[]{entry.getContainer()});
        ParametersChecker.checkParameter((String)ERR_WORKFLOW_IS_MANDATORY, (String[])new String[]{entry.getWorkflow()});
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/operations/" + entry.getContainer()).withHeader("X-Context-Id", (Object)entry.getWorkflow()).withHeader("X-ACTION", (Object)ProcessAction.INIT).withBody((Object)entry).withJson();
        try (Response response = this.make(request);){
            this.checkWithSpecificException(response);
        }
        catch (AccessUnauthorizedException | ConflictClientException | ForbiddenClientException | VitamClientInternalException e) {
            throw new InternalServerException(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase(), e);
        }
        catch (PreconditionFailedClientException e) {
            throw new IllegalArgumentException(ILLEGAL_ARGUMENT, e);
        }
    }

    @Override
    public RequestResponse<ItemStatus> executeOperationProcess(String operationId, String workflowId, String actionId) throws InternalServerException, VitamClientException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)BLANK_OPERATION_ID, (String[])new String[]{operationId});
            ParametersChecker.checkParameter((String)ACTION_ID_MUST_HAVE_A_VALID_VALUE, (String[])new String[]{actionId});
            ParametersChecker.checkParameter((String)"workflow is a mandatory parameter", (String[])new String[]{workflowId});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/operations/" + operationId).withHeader("X-ACTION", (Object)actionId).withHeader("X-Context-Id", (Object)workflowId).withBody((Object)new ProcessingEntry(operationId, workflowId)).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, ItemStatus.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BadRequestException | ConflictClientException | ForbiddenClientException | PreconditionFailedClientException | WorkflowNotFoundException e) {
                    throw new VitamClientInternalException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<ItemStatus> updateOperationActionProcess(String actionId, String operationId) throws InternalServerException, VitamClientException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)BLANK_OPERATION_ID, (String[])new String[]{operationId});
            ParametersChecker.checkParameter((String)ACTION_ID_MUST_HAVE_A_VALID_VALUE, (String[])new String[]{actionId});
            VitamRequestBuilder request = VitamRequestBuilder.put().withPath("/operations/" + operationId).withHeader("X-ACTION", (Object)actionId).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, ItemStatus.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BadRequestException | ConflictClientException | ForbiddenClientException | PreconditionFailedClientException | WorkflowNotFoundException e) {
                    throw new VitamClientInternalException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public ItemStatus getOperationProcessStatus(String operationId) throws InternalServerException, BadRequestException, VitamClientException {
        ItemStatus itemStatus;
        block10: {
            ParametersChecker.checkParameter((String)BLANK_OPERATION_ID, (String[])new String[]{operationId});
            VitamRequestBuilder request = VitamRequestBuilder.head().withPath("/operations/" + operationId).withJsonAccept();
            Response response = this.make(request);
            try {
                try {
                    this.checkWithSpecificException(response);
                }
                catch (ConflictClientException | ForbiddenClientException throwable) {
                    // empty catch block
                }
                itemStatus = ProcessingManagementClientRest.getItemStatusFromResponse(response);
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PreconditionFailedClientException e) {
                    throw new BadRequestException(ILLEGAL_ARGUMENT, (Throwable)e);
                }
            }
            response.close();
        }
        return itemStatus;
    }

    private static ItemStatus getItemStatusFromResponse(Response response) {
        return new ItemStatus().setGlobalState(ProcessState.valueOf((String)response.getHeaderString("X-Global-Execution-State"))).setLogbookTypeProcess(response.getHeaderString("X-Context-Id")).increment(StatusCode.valueOf((String)response.getHeaderString("X-Global-Execution-Status")));
    }

    @Override
    public RequestResponse<ItemStatus> getOperationProcessExecutionDetails(String id) throws InternalServerException, VitamClientException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)BLANK_OPERATION_ID, (String[])new String[]{id});
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/operations/" + id).withJsonAccept();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, ItemStatus.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BadRequestException | ConflictClientException | ForbiddenClientException | PreconditionFailedClientException | WorkflowNotFoundException e) {
                    throw new VitamClientInternalException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<ItemStatus> cancelOperationProcessExecution(String id) throws InternalServerException, VitamClientException {
        RequestResponse requestResponse;
        block8: {
            ParametersChecker.checkParameter((String)BLANK_OPERATION_ID, (String[])new String[]{id});
            VitamRequestBuilder request = VitamRequestBuilder.delete().withPath("/operations/" + id).withJsonAccept();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, ItemStatus.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BadRequestException | ConflictClientException | ForbiddenClientException | PreconditionFailedClientException | WorkflowNotFoundException e) {
                    throw new VitamClientInternalException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public void registerWorker(String familyId, String workerId, WorkerBean workerDescription) throws VitamClientInternalException, ProcessingBadRequestException {
        ParametersChecker.checkParameter((String)"familyId is a mandatory parameter", (String[])new String[]{familyId});
        ParametersChecker.checkParameter((String)"workerId is a mandatory parameter", (String[])new String[]{workerId});
        ParametersChecker.checkParameter((String)"workerDescription is a mandatory parameter", (Object[])new Object[]{workerDescription});
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/worker_family/" + familyId + "/workers/" + workerId).withBody((Object)workerDescription).withJson();
        try (Response response = this.make(request);){
            this.checkWithSpecificException(response);
        }
        catch (AccessUnauthorizedException | ConflictClientException | ForbiddenClientException | PreconditionFailedClientException | VitamClientInternalException | WorkflowNotFoundException e) {
            throw new ProcessingBadRequestException(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase(), e);
        }
        catch (BadRequestException e) {
            throw new ProcessingBadRequestException(BAD_REQUEST_EXCEPTION, (Throwable)e);
        }
        catch (InternalServerException e) {
            throw new VitamClientInternalException("Internal error while trying to register worker : family (" + familyId + "), workerId (" + workerId, (Throwable)e);
        }
    }

    @Override
    public void unregisterWorker(String familyId, String workerId) throws ProcessingBadRequestException {
        ParametersChecker.checkParameter((String)"familyId is a mandatory parameter", (String[])new String[]{familyId});
        ParametersChecker.checkParameter((String)"workerId is a mandatory parameter", (String[])new String[]{workerId});
        VitamRequestBuilder request = VitamRequestBuilder.delete().withPath("/worker_family/" + familyId + "/workers/" + workerId).withJsonAccept();
        try (Response response = this.make(request);){
            this.checkWithSpecificException(response);
        }
        catch (AccessUnauthorizedException | BadRequestException | ConflictClientException | ForbiddenClientException | InternalServerException | PreconditionFailedClientException | WorkflowNotFoundException e) {
            throw new ProcessingBadRequestException(e);
        }
        catch (VitamClientInternalException e) {
            throw new ProcessingBadRequestException(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase(), (Throwable)e);
        }
    }

    @Override
    public RequestResponse<ProcessDetail> listOperationsDetails(ProcessQuery query) throws VitamClientException {
        RequestResponse requestResponse;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath(OPERATION_URI).withBody((Object)query).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, ProcessDetail.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BadRequestException | ConflictClientException | ForbiddenClientException | InternalServerException | PreconditionFailedClientException | WorkflowNotFoundException e) {
                    throw new VitamClientInternalException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<WorkFlow> getWorkflowDefinitions() throws VitamClientException {
        RequestResponse requestResponse;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath(WORKFLOWS_URI).withJsonAccept();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, WorkFlow.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BadRequestException | ConflictClientException | ForbiddenClientException | InternalServerException | PreconditionFailedClientException | WorkflowNotFoundException | IllegalStateException e) {
                    throw new VitamClientInternalException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public Optional<WorkFlow> getWorkflowDetails(String workflowIdentifier) throws VitamClientException {
        Optional<WorkFlow> optional;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/workflows/" + workflowIdentifier).withJsonAccept();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                optional = Optional.of((WorkFlow)response.readEntity(WorkFlow.class));
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BadRequestException | ConflictClientException | ForbiddenClientException | InternalServerException | PreconditionFailedClientException e) {
                    throw new VitamClientInternalException(e);
                }
                catch (WorkflowNotFoundException e) {
                    return Optional.empty();
                }
            }
            response.close();
        }
        return optional;
    }

    @Override
    public RequestResponse<ProcessPause> forcePause(ProcessPause info) throws ProcessingException {
        RequestResponse requestResponse;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(FORCE_PAUSE_URI).withBody((Object)info).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, ProcessPause.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessUnauthorizedException | BadRequestException | ConflictClientException | ForbiddenClientException | InternalServerException | PreconditionFailedClientException | VitamClientInternalException | WorkflowNotFoundException e) {
                    throw new ProcessingException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<ProcessPause> removeForcePause(ProcessPause info) throws ProcessingException {
        RequestResponse requestResponse;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(REMOVE_FORCE_PAUSE_URI).withBody((Object)info).withJson();
            Response response = this.make(request);
            try {
                this.checkWithSpecificException(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, ProcessPause.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessUnauthorizedException | BadRequestException | ConflictClientException | ForbiddenClientException | InternalServerException | PreconditionFailedClientException | VitamClientInternalException | WorkflowNotFoundException e) {
                    throw new ProcessingException(e.getMessage(), e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    private void checkWithSpecificException(Response response) throws WorkflowNotFoundException, BadRequestException, AccessUnauthorizedException, ForbiddenClientException, ConflictClientException, VitamClientInternalException, PreconditionFailedClientException, InternalServerException {
        Response.Status status = Response.Status.fromStatusCode((int)response.getStatus());
        if (Response.Status.Family.SUCCESSFUL.equals((Object)status.getFamily())) {
            return;
        }
        switch (status) {
            case NOT_FOUND: {
                throw new WorkflowNotFoundException(status.getReasonPhrase());
            }
            case BAD_REQUEST: {
                String reason = response.hasEntity() ? (String)response.readEntity(String.class) : Response.Status.BAD_REQUEST.getReasonPhrase();
                throw new BadRequestException(reason);
            }
            case UNAUTHORIZED: {
                throw new AccessUnauthorizedException("Contract not found ");
            }
            case FORBIDDEN: {
                String reason = response.hasEntity() ? (String)response.readEntity(String.class) : Response.Status.BAD_REQUEST.getReasonPhrase();
                throw new ForbiddenClientException(reason);
            }
            case PRECONDITION_FAILED: {
                throw new PreconditionFailedClientException("Precondition Failed");
            }
            case CONFLICT: {
                throw new ConflictClientException(Response.Status.CONFLICT.getReasonPhrase());
            }
            case INTERNAL_SERVER_ERROR: {
                throw new InternalServerException(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase());
            }
        }
        throw new VitamClientInternalException(String.format("Error with the response, get status: '%d' and reason '%s'.", status, status.getReasonPhrase()));
    }
}

