/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.server.reconstruction;

import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.metrics.PassiveExpiringCache;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;

public class LogbookReconstructionMetricsCache {
    private final PassiveExpiringCache<Integer, LocalDateTime> reconstructionStatsCache;

    public LogbookReconstructionMetricsCache(long cacheDuration, TimeUnit cacheDurationUnit) {
        this.reconstructionStatsCache = new PassiveExpiringCache(cacheDuration, cacheDurationUnit);
    }

    public void registerLastReconstructedDocumentDate(int tenant, LocalDateTime lastReconstructedDocumentDate) {
        ParametersChecker.checkParameter((String)"Missing lastReconstructedDocumentDate", (Object[])new Object[]{lastReconstructedDocumentDate});
        this.reconstructionStatsCache.put((Object)tenant, (Object)lastReconstructedDocumentDate);
    }

    public Duration getLogbookOperationReconstructionLatency(int tenant) {
        LocalDateTime lastReconstructedDocumentDate = (LocalDateTime)this.reconstructionStatsCache.get((Object)tenant);
        if (lastReconstructedDocumentDate == null) {
            return null;
        }
        return Duration.between(lastReconstructedDocumentDate, LocalDateUtil.now());
    }
}

