/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.server.database.collections;

import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSet;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchAccess;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexAlias;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexSettings;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchNode;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchUtil;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.logbook.common.server.config.ElasticsearchLogbookIndexManager;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookCollections;
import fr.gouv.vitam.logbook.common.server.exception.LogbookException;
import fr.gouv.vitam.logbook.common.server.exception.LogbookExecutionException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class LogbookElasticsearchAccess
extends ElasticsearchAccess {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookElasticsearchAccess.class);
    public static final String MAPPING_LOGBOOK_OPERATION_FILE = "/logbook-es-mapping.json";
    private final ElasticsearchLogbookIndexManager indexManager;

    public LogbookElasticsearchAccess(String clusterName, List<ElasticsearchNode> nodes, ElasticsearchLogbookIndexManager indexManager) throws VitamException {
        super(clusterName, nodes);
        this.indexManager = indexManager;
    }

    public void createIndexesAndAliases() {
        try {
            this.createIndexesAndAliasesForDedicatedTenants();
            this.createIndexesAndAliasesForTenantGroups();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            throw new RuntimeException("Could not create indexes and aliases", e);
        }
    }

    private void createIndexesAndAliasesForDedicatedTenants() throws LogbookExecutionException {
        List<Integer> dedicatedTenants = this.indexManager.getDedicatedTenants();
        Iterator iterator = dedicatedTenants.iterator();
        while (iterator.hasNext()) {
            int tenantId = (Integer)iterator.next();
            this.createIndexAndAliasIfAliasNotExists(LogbookCollections.OPERATION, tenantId);
        }
    }

    private void createIndexesAndAliasesForTenantGroups() throws LogbookExecutionException {
        Collection<String> tenantGroups = this.indexManager.getTenantGroups();
        for (String tenantGroup : tenantGroups) {
            List<Integer> tenantGroupTenants = this.indexManager.getTenantGroupTenants(tenantGroup);
            if (tenantGroupTenants.isEmpty()) continue;
            int tenantId = (Integer)tenantGroupTenants.iterator().next();
            this.createIndexAndAliasIfAliasNotExists(LogbookCollections.OPERATION, tenantId);
        }
    }

    private void createIndexAndAliasIfAliasNotExists(LogbookCollections collection, Integer tenantId) throws LogbookExecutionException {
        try {
            ElasticsearchIndexAlias indexAlias = this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenantId);
            ElasticsearchIndexSettings indexSettings = this.indexManager.getElasticsearchIndexSettings(collection, tenantId);
            super.createIndexAndAliasIfAliasNotExists(indexAlias, indexSettings, this.indexManager.getElasticsearchConfigurationFile());
        }
        catch (Exception e) {
            throw new LogbookExecutionException("Error while set Mapping", e);
        }
    }

    final <T> void updateFullDocument(LogbookCollections collection, Integer tenantId, String id, VitamDocument<T> logbookDocument) throws LogbookExecutionException {
        try {
            ElasticsearchIndexAlias indexAlias = this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenantId);
            super.updateEntry(indexAlias, id, logbookDocument);
        }
        catch (DatabaseException e) {
            throw new LogbookExecutionException(e);
        }
    }

    public final ResponseBody<ObjectNode> search(LogbookCollections collection, Integer tenantId, Query query, List<SortOptions> sorts, int offset, int limit) throws LogbookException {
        try {
            int size = Math.min(10000, limit);
            ElasticsearchIndexAlias indexAlias = this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenantId);
            Query finalQuery = ElasticsearchUtil.boolMust((Query[])new Query[]{query, ElasticsearchUtil.termQuery((String)"_tenant", (int)tenantId)});
            return super.search(indexAlias, finalQuery, VitamDocument.ES_FILTER_OUT, sorts, offset, Integer.valueOf(size), null, null, null, false);
        }
        catch (BadRequestException | DatabaseException e) {
            throw new LogbookExecutionException(e);
        }
    }

    public final ResponseBody<ObjectNode> searchCrossIndices(LogbookCollections collection, Integer tenantId, Query query, List<SortOptions> sorts, int offset, int limit) throws LogbookException {
        try {
            int size = Math.min(10000, limit);
            ElasticsearchIndexAlias indexAlias = this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenantId);
            if (ParameterHelper.getTenantParameter().equals(VitamConfiguration.getAdminTenant())) {
                Query finalQuery = ElasticsearchUtil.boolMust((Query[])new Query[]{query, ElasticsearchUtil.termQuery((String)"_tenant", (int)tenantId)});
                return super.search(indexAlias, finalQuery, VitamDocument.ES_FILTER_OUT, sorts, offset, Integer.valueOf(size), null, null, null, false);
            }
            ElasticsearchIndexAlias adminTenantIndex = this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(VitamConfiguration.getAdminTenant());
            Query finalQuery = ElasticsearchUtil.boolMust((Query[])new Query[]{query, ElasticsearchUtil.boolShould((Query[])new Query[]{ElasticsearchUtil.termQuery((String)"_tenant", (int)tenantId), ElasticsearchUtil.boolMust((Query[])new Query[]{ElasticsearchUtil.termsQuery((String)"evType", (String[])LogbookCollections.MULTI_TENANT_EV_TYPES), ElasticsearchUtil.termQuery((String)"_tenant", (int)VitamConfiguration.getAdminTenant())})})});
            return super.searchCrossIndices((Set)ImmutableSet.of((Object)indexAlias, (Object)adminTenantIndex), finalQuery, VitamDocument.ES_FILTER_OUT, sorts, offset, Integer.valueOf(size), null, null, null, false);
        }
        catch (BadRequestException | DatabaseException e) {
            throw new LogbookExecutionException(e);
        }
    }

    public void deleteIndexByAliasForTesting(LogbookCollections collection, int tenantId) throws LogbookExecutionException {
        try {
            super.deleteIndexByAliasForTesting(this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(Integer.valueOf(tenantId)));
        }
        catch (DatabaseException e) {
            throw new LogbookExecutionException(e);
        }
    }

    public <T> void indexEntry(LogbookCollections collection, Integer tenantId, String id, VitamDocument<T> vitamDocument) throws LogbookExecutionException {
        try {
            super.indexEntry(this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenantId), id, vitamDocument);
        }
        catch (DatabaseException e) {
            throw new LogbookExecutionException(e);
        }
    }

    public void refreshIndex(LogbookCollections collection, int tenantId) throws LogbookExecutionException {
        try {
            super.refreshIndex(this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(Integer.valueOf(tenantId)));
        }
        catch (DatabaseException e) {
            throw new LogbookExecutionException(e);
        }
    }

    public void purgeIndexForTesting(LogbookCollections collection, Integer tenantId) throws LogbookExecutionException {
        try {
            ElasticsearchIndexAlias indexAlias = this.indexManager.getElasticsearchIndexAliasResolver(collection).resolveIndexName(tenantId);
            super.purgeIndexForTesting(indexAlias, tenantId);
        }
        catch (DatabaseException e) {
            throw new LogbookExecutionException(e);
        }
    }
}

