/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.server.config;

import fr.gouv.vitam.common.model.config.CollectionConfiguration;
import fr.gouv.vitam.common.model.config.CollectionConfigurationUtils;
import fr.gouv.vitam.common.model.config.TenantRange;
import fr.gouv.vitam.common.model.config.TenantRangeParser;
import fr.gouv.vitam.logbook.common.server.config.DedicatedTenantConfiguration;
import fr.gouv.vitam.logbook.common.server.config.GroupedTenantConfiguration;
import fr.gouv.vitam.logbook.common.server.config.LogbookConfiguration;
import fr.gouv.vitam.logbook.common.server.config.LogbookIndexationConfiguration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class LogbookConfigurationValidator {
    public static final String TENANT_GROUP_NAME_PATTERN = "^[a-z][a-z0-9]{1,63}$";

    public static void validateConfiguration(LogbookConfiguration logbookConfiguration) {
        if (logbookConfiguration == null) {
            throw new IllegalStateException("Invalid configuration. Null config");
        }
        LogbookConfigurationValidator.validateElasticsearchIndexationConfiguration(logbookConfiguration.getLogbookTenantIndexation());
    }

    private static void validateElasticsearchIndexationConfiguration(LogbookIndexationConfiguration indexationConfiguration) {
        if (indexationConfiguration == null) {
            throw new IllegalStateException("Invalid configuration. Missing ES tenant indexation");
        }
        LogbookConfigurationValidator.validateDefaultConfig(indexationConfiguration);
        LogbookConfigurationValidator.validateTenantGroupNames(indexationConfiguration);
        LogbookConfigurationValidator.validateTenantRanges(indexationConfiguration);
        LogbookConfigurationValidator.validateCollectionConfiguration(indexationConfiguration);
    }

    private static void validateDefaultConfig(LogbookIndexationConfiguration config) throws IllegalStateException {
        if (config.getDefaultCollectionConfiguration() == null) {
            throw new IllegalStateException("Invalid configuration. Missing default configuration");
        }
        CollectionConfigurationUtils.validate((CollectionConfiguration)config.getDefaultCollectionConfiguration().getLogbookoperation(), (boolean)false);
    }

    private static void validateTenantGroupNames(LogbookIndexationConfiguration indexationConfiguration) {
        if (CollectionUtils.isEmpty(indexationConfiguration.getGroupedTenantConfiguration())) {
            return;
        }
        HashSet tenantGroupNames = new HashSet();
        indexationConfiguration.getGroupedTenantConfiguration().stream().map(GroupedTenantConfiguration::getName).forEach(name -> {
            if (name == null) {
                throw new IllegalStateException("Invalid configuration. Missing tenant group name");
            }
            if (!name.matches(TENANT_GROUP_NAME_PATTERN)) {
                throw new IllegalStateException("Invalid configuration. Tenant group name '" + name + "' does not match regex ^[a-z][a-z0-9]{1,63}$");
            }
            if (!tenantGroupNames.add(name)) {
                throw new IllegalStateException("Invalid configuration. Duplicate tenant group name " + name);
            }
        });
    }

    private static void validateTenantRanges(LogbookIndexationConfiguration indexationConfiguration) {
        ArrayList tenantRangeStrings = new ArrayList();
        if (CollectionUtils.isNotEmpty(indexationConfiguration.getGroupedTenantConfiguration())) {
            indexationConfiguration.getGroupedTenantConfiguration().stream().map(GroupedTenantConfiguration::getTenants).forEach(tenantRangeStrings::add);
        }
        if (CollectionUtils.isNotEmpty(indexationConfiguration.getDedicatedTenantConfiguration())) {
            indexationConfiguration.getDedicatedTenantConfiguration().stream().map(DedicatedTenantConfiguration::getTenants).forEach(tenantRangeStrings::add);
        }
        if (tenantRangeStrings.contains(null)) {
            throw new IllegalStateException("Invalid configuration. Missing tenants from dedicated tenant or grouped tenant configuration");
        }
        List tenantRanges = tenantRangeStrings.stream().flatMap(tenantRangeString -> TenantRangeParser.parseTenantRanges((String)tenantRangeString).stream()).collect(Collectors.toList());
        for (int i = 0; i < tenantRanges.size(); ++i) {
            for (int j = i + 1; j < tenantRanges.size(); ++j) {
                if (!TenantRangeParser.doRangesIntersect((TenantRange)((TenantRange)tenantRanges.get(i)), (TenantRange)((TenantRange)tenantRanges.get(j)))) continue;
                throw new IllegalStateException("Invalid configuration. Overlapping tenant ranges " + String.valueOf(tenantRanges.get(i)) + " and " + String.valueOf(tenantRanges.get(j)));
            }
        }
    }

    private static void validateCollectionConfiguration(LogbookIndexationConfiguration indexationConfiguration) {
        if (CollectionUtils.isNotEmpty(indexationConfiguration.getDedicatedTenantConfiguration())) {
            for (DedicatedTenantConfiguration dedicatedTenantConfiguration : indexationConfiguration.getDedicatedTenantConfiguration()) {
                if (dedicatedTenantConfiguration.getLogbookoperation() == null) continue;
                CollectionConfigurationUtils.validate((CollectionConfiguration)dedicatedTenantConfiguration.getLogbookoperation(), (boolean)true);
            }
        }
        if (CollectionUtils.isNotEmpty(indexationConfiguration.getGroupedTenantConfiguration())) {
            for (GroupedTenantConfiguration groupedTenantConfiguration : indexationConfiguration.getGroupedTenantConfiguration()) {
                if (groupedTenantConfiguration.getLogbookoperation() == null) continue;
                CollectionConfigurationUtils.validate((CollectionConfiguration)groupedTenantConfiguration.getLogbookoperation(), (boolean)true);
            }
        }
    }
}

