/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.storage.s3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.ApacheHttpClientConfig;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.SdkBaseException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.internal.BucketNameUtils;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazonaws.services.s3.model.CopyPartResult;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.MetadatasObject;
import fr.gouv.vitam.common.model.storage.ObjectEntry;
import fr.gouv.vitam.common.performance.PerformanceLogger;
import fr.gouv.vitam.common.retryable.RetryableOnException;
import fr.gouv.vitam.common.retryable.RetryableParameters;
import fr.gouv.vitam.common.storage.ContainerInformation;
import fr.gouv.vitam.common.storage.StorageConfiguration;
import fr.gouv.vitam.common.storage.cas.container.api.ContentAddressableStorageAbstract;
import fr.gouv.vitam.common.storage.cas.container.api.MetadatasStorageObject;
import fr.gouv.vitam.common.storage.cas.container.api.ObjectContent;
import fr.gouv.vitam.common.storage.cas.container.api.ObjectListingListener;
import fr.gouv.vitam.common.storage.constants.ErrorMessage;
import fr.gouv.vitam.common.storage.s3.AmazonS3APIErrorCodes;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageDigestMismatchException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.ssl.SSLContexts;

public class AmazonS3V1
extends ContentAddressableStorageAbstract {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AmazonS3V1.class);
    private static final String X_OBJECT_META_DIGEST = "Digest";
    private static final String X_OBJECT_META_DIGEST_TYPE = "Digest-Type";
    private static final HostnameVerifier ALLOW_ALL_HOSTNAME_VERIFIER = NoopHostnameVerifier.INSTANCE;
    private static final AlertService ALERT_SERVICE = new AlertServiceImpl();
    private static final long MB_TO_BYTES = 0x100000L;
    private final AmazonS3 client;
    private final boolean s3DisableMultipartUpload;
    private final long s3MaxUploadPartSize;
    private final int s3MultiPartCleanNbRetries;
    private final int s3MultiPartCleanWaitingTimeInMilliseconds;

    public AmazonS3V1(StorageConfiguration configuration) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        super(configuration);
        AmazonS3V1.checkConfiguration(configuration);
        this.s3DisableMultipartUpload = configuration.isS3DisableMultipartUpload();
        this.s3MaxUploadPartSize = configuration.getS3MaxUploadPartSizeMB() * 0x100000L;
        this.s3MultiPartCleanNbRetries = configuration.getS3MultiPartCleanNbRetries();
        this.s3MultiPartCleanWaitingTimeInMilliseconds = configuration.getS3MultiPartCleanWaitingTimeInMilliseconds();
        LOGGER.debug("Instanciation of amazon S3 V1 client");
        AwsClientBuilder.EndpointConfiguration endpointConfiguration = new AwsClientBuilder.EndpointConfiguration(configuration.getS3Endpoint(), configuration.getS3RegionName());
        ClientConfiguration clientConfig = new ClientConfiguration();
        if (StringUtils.isNotBlank((String)configuration.getS3SignerType())) {
            clientConfig.setSignerOverride(configuration.getS3SignerType());
        }
        if (configuration.getS3MaxConnections() > 0) {
            clientConfig.setMaxConnections(configuration.getS3MaxConnections());
        }
        if (configuration.getS3ConnectionTimeout() >= 0) {
            clientConfig.setConnectionTimeout(configuration.getS3ConnectionTimeout());
        }
        if (configuration.getS3SocketTimeout() >= 0) {
            clientConfig.setSocketTimeout(configuration.getS3SocketTimeout());
        }
        clientConfig.setRequestTimeout(configuration.getS3RequestTimeout());
        clientConfig.setClientExecutionTimeout(configuration.getS3ClientExecutionTimeout());
        if (configuration.getS3Endpoint().startsWith("https")) {
            ApacheHttpClientConfig apacheClient = clientConfig.getApacheHttpClientConfig();
            File file = new File(configuration.getS3TrustStore());
            SSLContext ctx = SSLContexts.custom().loadTrustMaterial(file, configuration.getS3TrustStorePassword().toCharArray()).build();
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(ctx, ALLOW_ALL_HOSTNAME_VERIFIER);
            apacheClient.withSslSocketFactory((ConnectionSocketFactory)sslConnectionSocketFactory);
        }
        BasicAWSCredentials credentials = new BasicAWSCredentials(configuration.getS3AccessKey(), configuration.getS3SecretKey());
        this.client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)credentials))).withClientConfiguration(clientConfig)).withEndpointConfiguration(endpointConfiguration)).withPathStyleAccessEnabled(Boolean.valueOf(configuration.isS3PathStyleAccessEnabled()))).build();
    }

    private static void checkConfiguration(StorageConfiguration configuration) {
        if (configuration.isS3DisableMultipartUpload()) {
            return;
        }
        if (configuration.getS3MaxUploadPartSizeMB() < 5L || configuration.getS3MaxUploadPartSizeMB() > 5120L) {
            throw new IllegalArgumentException("Invalid max part upload size %d. Valid values must be in the range [%d MB - %d MB]".formatted(configuration.getS3MaxUploadPartSizeMB(), 5120, 5120));
        }
    }

    @VisibleForTesting
    AmazonS3V1(StorageConfiguration configuration, AmazonS3 client) {
        super(configuration);
        this.client = client;
        this.s3DisableMultipartUpload = configuration.isS3DisableMultipartUpload();
        this.s3MaxUploadPartSize = configuration.getS3MaxUploadPartSizeMB() * 0x100000L;
        this.s3MultiPartCleanNbRetries = configuration.getS3MultiPartCleanNbRetries();
        this.s3MultiPartCleanWaitingTimeInMilliseconds = configuration.getS3MultiPartCleanWaitingTimeInMilliseconds();
    }

    @Override
    public void createContainer(String containerName) throws ContentAddressableStorageServerException {
        LOGGER.debug(String.format("Create container %s", containerName));
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_NAME_IS_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName});
        String bucketName = this.generateBucketName(containerName);
        try {
            this.client.createBucket(bucketName);
        }
        catch (AmazonServiceException e) {
            LOGGER.debug(String.format("Error when trying to create container with name: %s. Reason: errorCode=%s, errorType=%s, errorMessage=%s", containerName, e.getErrorCode(), e.getErrorType(), e.getErrorMessage()), (Throwable)e);
            if (AmazonS3APIErrorCodes.BUCKET_ALREADY_EXISTS.getErrorCode().equals(e.getErrorCode()) || AmazonS3APIErrorCodes.BUCKET_ALREADY_OWNED_BY_YOU.getErrorCode().equals(e.getErrorCode())) {
                LOGGER.warn("Container " + containerName + " already exists");
            }
            throw new ContentAddressableStorageServerException("Error when trying to create container", (Throwable)e);
        }
        catch (SdkBaseException e) {
            LOGGER.debug(String.format("Error when trying to create container with name: %s. Reason: errorMessage=%s", containerName, e.getMessage()), (Throwable)e);
            throw new ContentAddressableStorageServerException("Error when trying to create container", (Throwable)e);
        }
    }

    @Override
    public boolean isExistingContainer(String containerName) throws ContentAddressableStorageServerException {
        LOGGER.debug(String.format("Check existence of container %s", containerName));
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_NAME_IS_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName});
        String bucketName = this.generateBucketName(containerName);
        if (super.isExistingContainerInCache(containerName)) {
            return true;
        }
        try {
            boolean exists = this.client.doesBucketExistV2(bucketName);
            this.cacheExistsContainer(containerName, exists);
            return exists;
        }
        catch (SdkBaseException e) {
            LOGGER.debug(String.format("Error when checking existence of container %s. Reason: errorMessage=%s", containerName, e.getMessage()), (Throwable)e);
            throw new ContentAddressableStorageServerException("Error when trying to check existence of container", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObject(String containerName, String objectName, InputStream inputStream, DigestType digestType, long size) throws ContentAddressableStorageException {
        LOGGER.debug(String.format("Upload object %s in container %s", objectName, containerName));
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_OBJECT_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, objectName});
        String bucketName = this.generateBucketName(containerName);
        Stopwatch times = Stopwatch.createStarted();
        try {
            if (this.useMultipartUpload(size)) {
                this.putLargeObject(bucketName, objectName, inputStream, size);
            } else {
                this.putSmallObject(bucketName, objectName, inputStream, size);
            }
        }
        finally {
            PerformanceLogger.getInstance().log("STP_Offer_" + this.getConfiguration().getProvider(), containerName, "REAL_S3_PUT_OBJECT", times.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    @Override
    public void checkObjectDigestAndStoreDigest(String containerName, String objectName, String objectDigest, DigestType digestType, long size) throws ContentAddressableStorageException {
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_OBJECT_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, objectName});
        String bucketName = this.generateBucketName(containerName);
        String computedDigest = this.computeObjectDigest(containerName, objectName, digestType);
        if (!objectDigest.equals(computedDigest)) {
            throw new ContentAddressableStorageDigestMismatchException("Illegal state for container " + containerName + " and object " + objectName + ". Stream digest " + objectDigest + " is not equal to computed digest " + computedDigest);
        }
        this.storeDigest(containerName, objectName, digestType, objectDigest, bucketName, size);
    }

    private void putLargeObject(String bucketName, String objectName, InputStream stream, long size) throws ContentAddressableStorageServerException {
        LOGGER.info("Uploading large object {}/{} ({} bytes)", new Object[]{bucketName, objectName, size});
        String uploadId = null;
        boolean uploadSucceeded = false;
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            ObjectMetadata objectMetadata = AmazonS3V1.createObjectMetadata(size);
            uploadId = this.initiateMultipartUpload(bucketName, objectName, objectMetadata);
            ArrayList<PartETag> partETags = new ArrayList<PartETag>();
            long sentBytes = 0L;
            long nbParts = (size + this.s3MaxUploadPartSize - 1L) / this.s3MaxUploadPartSize;
            int partNumber = 1;
            while (sentBytes < size) {
                long partSize = Math.min(this.s3MaxUploadPartSize, size - sentBytes);
                PartETag partETag = this.uploadPart(bucketName, objectName, stream, partNumber, nbParts, partSize, uploadId, sentBytes);
                partETags.add(partETag);
                sentBytes += partSize;
                ++partNumber;
            }
            this.completeMultipartUpload(bucketName, objectName, uploadId, partETags);
            uploadSucceeded = true;
            LOGGER.info("Large object {}/{} uploaded successfully  ({} bytes, {} ms)", new Object[]{bucketName, objectName, size, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        }
        catch (SdkBaseException e) {
            throw new ContentAddressableStorageServerException(String.format("Error when trying to upload object %s/%s. Reason: errorMessage=%s", bucketName, objectName, e.getMessage()), (Throwable)e);
        }
        finally {
            StreamUtils.closeSilently((InputStream)stream);
            if (uploadId != null && !uploadSucceeded) {
                this.tryCleanupMultiPartUpload(bucketName, objectName, uploadId);
            }
        }
    }

    private String initiateMultipartUpload(String containerName, String objectName, ObjectMetadata objectMetadata) throws SdkBaseException {
        LOGGER.debug("Initiating multipart upload {}/{}", (Object)containerName, (Object)objectName);
        InitiateMultipartUploadResult initiateMultipartUploadResult = this.client.initiateMultipartUpload(new InitiateMultipartUploadRequest(containerName, objectName, objectMetadata));
        String uploadId = initiateMultipartUploadResult.getUploadId();
        LOGGER.debug("Initiated multipart upload {}", (Object)uploadId);
        return uploadId;
    }

    private PartETag uploadPart(String containerName, String objectName, InputStream stream, int partNumber, long nbParts, long partSize, String uploadId, long offset) throws ContentAddressableStorageServerException {
        PartETag partETag;
        block8: {
            LOGGER.info("Multipart upload of {}/{} - Part {}/{} ({} bytes)", new Object[]{containerName, objectName, partNumber, nbParts, partSize});
            BoundedInputStream partInputStream = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream(stream)).setMaxCount(partSize)).setPropagateClose(false)).get();
            try {
                UploadPartRequest uploadPartRequest = new UploadPartRequest().withInputStream((InputStream)partInputStream).withBucketName(containerName).withUploadId(uploadId).withFileOffset(0L).withPartSize(partSize).withPartNumber(partNumber).withKey(objectName);
                UploadPartResult uploadPartResult = this.client.uploadPart(uploadPartRequest);
                partETag = uploadPartResult.getPartETag();
                if (partInputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (partInputStream != null) {
                        try {
                            partInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ContentAddressableStorageServerException((Throwable)e);
                }
            }
            partInputStream.close();
        }
        return partETag;
    }

    private void completeMultipartUpload(String bucketName, String objectName, String uploadId, List<PartETag> partETags) {
        LOGGER.debug("Completing multi-part upload {} of {}/{}", new Object[]{uploadId, bucketName, objectName});
        CompleteMultipartUploadRequest compRequest = new CompleteMultipartUploadRequest(bucketName, objectName, uploadId, partETags);
        this.client.completeMultipartUpload(compRequest);
    }

    private void tryCleanupMultiPartUpload(String bucketName, String objectName, String uploadId) {
        try {
            new RetryableOnException(new RetryableParameters(this.s3MultiPartCleanNbRetries, this.s3MultiPartCleanWaitingTimeInMilliseconds, this.s3MultiPartCleanWaitingTimeInMilliseconds, this.s3MultiPartCleanWaitingTimeInMilliseconds, TimeUnit.MILLISECONDS)).exec(() -> {
                LOGGER.error("Multi-part upload for object {}/{} with id {} failed. Cleaning up...", new Object[]{bucketName, objectName, uploadId});
                this.client.abortMultipartUpload(new AbortMultipartUploadRequest(bucketName, objectName, uploadId));
                return null;
            });
            LOGGER.warn("Cleanup of multi-part upload for object {}/{} with id {} succeeded", new Object[]{bucketName, objectName, uploadId});
        }
        catch (Exception e) {
            String msg = String.format("An error occurred during multi-part upload for object %s/%s with id %s.Please cleanup your S3 storage server manually using the S3 AbortMultipartUpload API", bucketName, objectName, uploadId);
            ALERT_SERVICE.createAlert(msg);
            LOGGER.error(msg, (Throwable)e);
        }
    }

    private void putSmallObject(String bucketName, String objectName, InputStream stream, long size) throws ContentAddressableStorageServerException, ContentAddressableStorageNotFoundException {
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentLength(size);
        try {
            this.client.putObject(bucketName, objectName, stream, objectMetadata);
        }
        catch (AmazonServiceException e) {
            LOGGER.debug(String.format("Error when trying to upload object %s/%s. Reason: errorMessage=%s", bucketName, objectName, e.getMessage()), (Throwable)e);
            if (AmazonS3APIErrorCodes.NO_SUCH_BUCKET.getErrorCode().equals(e.getErrorCode())) {
                throw new ContentAddressableStorageNotFoundException("Error when trying to upload object : container does not exists", (Throwable)e);
            }
            throw new ContentAddressableStorageServerException("Error when trying to upload object", (Throwable)e);
        }
        catch (SdkBaseException e) {
            LOGGER.debug(String.format("Error when trying to upload object %s/%s. Reason: errorMessage=%s", bucketName, objectName, e.getMessage()), (Throwable)e);
            throw new ContentAddressableStorageServerException("Error when trying to upload object", (Throwable)e);
        }
    }

    private void storeDigest(String containerName, String objectName, DigestType digestType, String digest, String bucketName, long size) throws ContentAddressableStorageException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (this.useMultipartUpload(size)) {
            this.storeLargeObjectDigest(bucketName, objectName, digestType, digest, size);
        } else {
            this.storeSmallObjectDigest(bucketName, objectName, digestType, digest, size);
        }
        PerformanceLogger.getInstance().log("STP_Offer_" + this.getConfiguration().getProvider(), containerName, "STORE_DIGEST_IN_METADATA", stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    private void storeSmallObjectDigest(String bucketName, String objectName, DigestType digestType, String digest, Long size) throws ContentAddressableStorageException {
        ObjectMetadata metadataToUpdate = AmazonS3V1.createObjectMetadata(digestType, digest, size);
        CopyObjectRequest request = new CopyObjectRequest(bucketName, objectName, bucketName, objectName).withNewObjectMetadata(metadataToUpdate);
        try {
            CopyObjectResult updateMetadataResult = this.client.copyObject(request);
            if (updateMetadataResult == null) {
                LOGGER.error("Failed to update object metadata -> try remove object");
                throw new ContentAddressableStorageServerException("Cannot put object " + bucketName + "/" + objectName);
            }
        }
        catch (SdkBaseException e) {
            LOGGER.debug(String.format("Error when trying to update metadata of object %s/%s. Reason: errorMessage=%s", bucketName, objectName, e.getMessage()), (Throwable)e);
            throw new ContentAddressableStorageServerException("Error when trying to update metadata of object", (Throwable)e);
        }
    }

    private static ObjectMetadata createObjectMetadata(Long size) {
        ObjectMetadata metadataToUpdate = new ObjectMetadata();
        metadataToUpdate.setContentLength(size.longValue());
        return metadataToUpdate;
    }

    private static ObjectMetadata createObjectMetadata(DigestType digestType, String digest, Long size) {
        ObjectMetadata metadataToUpdate = new ObjectMetadata();
        metadataToUpdate.setContentLength(size.longValue());
        metadataToUpdate.addUserMetadata(X_OBJECT_META_DIGEST, digest);
        metadataToUpdate.addUserMetadata(X_OBJECT_META_DIGEST_TYPE, digestType.getName());
        return metadataToUpdate;
    }

    private void storeLargeObjectDigest(String bucketName, String objectName, DigestType digestType, String digest, long size) throws ContentAddressableStorageException {
        LOGGER.info("Updating digest for large object {}/{} (digest: {}, size: {} bytes)", new Object[]{bucketName, objectName, digest, size});
        String copyObjectUploadId = null;
        boolean copySucceeded = false;
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            ObjectMetadata metadataToUpdate = AmazonS3V1.createObjectMetadata(digestType, digest, size);
            copyObjectUploadId = this.initiateMultipartUpload(bucketName, objectName, metadataToUpdate);
            ArrayList<PartETag> partETags = new ArrayList<PartETag>();
            long offset = 0L;
            long nbParts = (size + this.s3MaxUploadPartSize - 1L) / this.s3MaxUploadPartSize;
            int partNumber = 1;
            while (offset < size) {
                long partSize = Math.min(this.s3MaxUploadPartSize, size - offset);
                PartETag partETag = this.copyPart(bucketName, objectName, partNumber, nbParts, partSize, copyObjectUploadId, offset);
                partETags.add(partETag);
                offset += partSize;
                ++partNumber;
            }
            this.completeMultipartUpload(bucketName, objectName, copyObjectUploadId, partETags);
            copySucceeded = true;
            LOGGER.info("Large object {}/{} updated successfully with digest {} ({} bytes, {} ms)", new Object[]{bucketName, objectName, digest, size, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
            if (copyObjectUploadId != null && !copySucceeded) {
                this.tryCleanupMultiPartUpload(bucketName, objectName, copyObjectUploadId);
            }
        }
        catch (SdkBaseException e) {
            try {
                throw new ContentAddressableStorageServerException(String.format("Error when trying to updating large object digest %s/%s. Reason: errorMessage=%s", bucketName, objectName, e.getMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                if (copyObjectUploadId != null && !copySucceeded) {
                    this.tryCleanupMultiPartUpload(bucketName, objectName, copyObjectUploadId);
                }
                throw throwable;
            }
        }
    }

    private PartETag copyPart(String containerName, String objectName, int partNumber, long nbParts, long partSize, String uploadId, long offset) {
        LOGGER.info("Copying multi-part for digest update of {}/{} - Part {}/{} ({} bytes)", new Object[]{containerName, objectName, partNumber, nbParts, partSize});
        CopyPartRequest copyRequest = new CopyPartRequest().withSourceBucketName(containerName).withSourceKey(objectName).withDestinationBucketName(containerName).withDestinationKey(objectName).withUploadId(uploadId).withFirstByte(Long.valueOf(offset)).withLastByte(Long.valueOf(offset + partSize - 1L)).withPartNumber(partNumber);
        CopyPartResult copyPartResult = this.client.copyPart(copyRequest);
        return copyPartResult.getPartETag();
    }

    @Override
    public ObjectContent getObject(String containerName, String objectName) throws ContentAddressableStorageException {
        LOGGER.debug(String.format("Download object %s from container %s", objectName, containerName));
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_OBJECT_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, objectName});
        String bucketName = this.generateBucketName(containerName);
        GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, objectName);
        try {
            S3Object object = this.client.getObject(getObjectRequest);
            long size = object.getObjectMetadata().getContentLength();
            S3ObjectInputStream inputStream = object.getObjectContent();
            return new ObjectContent((InputStream)inputStream, size);
        }
        catch (AmazonServiceException e) {
            LOGGER.debug(String.format("Error when trying to download object %s from container %s. Reason: errorCode=%s, errorType=%s, errorMessage=%s", objectName, containerName, e.getErrorCode(), e.getErrorType(), e.getErrorMessage()), (Throwable)e);
            if (AmazonS3APIErrorCodes.NO_SUCH_KEY.getErrorCode().equals(e.getErrorCode())) {
                throw new ContentAddressableStorageNotFoundException(ErrorMessage.OBJECT_NOT_FOUND.getMessage() + objectName, (Throwable)e);
            }
            if (AmazonS3APIErrorCodes.NO_SUCH_BUCKET.getErrorCode().equals(e.getErrorCode())) {
                throw new ContentAddressableStorageNotFoundException(ErrorMessage.CONTAINER_NOT_FOUND.getMessage() + containerName, (Throwable)e);
            }
            throw new ContentAddressableStorageServerException("Error when trying to download object", (Throwable)e);
        }
        catch (SdkBaseException e) {
            LOGGER.debug(String.format("Error when trying to download object %s from container %s. Reason: errorMessage=%s", objectName, containerName, e.getMessage()), (Throwable)e);
            throw new ContentAddressableStorageServerException("Error when trying to download object", (Throwable)e);
        }
    }

    @Override
    public void deleteObject(String containerName, String objectName) throws ContentAddressableStorageException {
        LOGGER.debug(String.format("Delete object %s from container %s", objectName, containerName));
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_OBJECT_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, objectName});
        String bucketName = this.generateBucketName(containerName);
        DeleteObjectRequest deleteObjectRequest = new DeleteObjectRequest(bucketName, objectName);
        try {
            this.client.deleteObject(deleteObjectRequest);
        }
        catch (AmazonServiceException e) {
            LOGGER.debug(String.format("Error when trying to delete object %s from container %s. Reason: errorCode=%s, errorType=%s, errorMessage=%s", objectName, containerName, e.getErrorCode(), e.getErrorType(), e.getErrorMessage()), (Throwable)e);
            if (AmazonS3APIErrorCodes.NO_SUCH_BUCKET.getErrorCode().equals(e.getErrorCode())) {
                throw new ContentAddressableStorageNotFoundException(ErrorMessage.CONTAINER_NOT_FOUND.getMessage() + containerName, (Throwable)e);
            }
            throw new ContentAddressableStorageServerException("Error when trying to delete object", (Throwable)e);
        }
        catch (SdkBaseException e) {
            LOGGER.debug(String.format("Error when trying to delete object %s from container %s. Reason: errorMessage=%s", objectName, containerName, e.getMessage()), (Throwable)e);
            throw new ContentAddressableStorageServerException("Error when trying to delete object " + objectName, (Throwable)e);
        }
    }

    @Override
    public boolean isExistingObject(String containerName, String objectName) throws ContentAddressableStorageServerException {
        LOGGER.debug(String.format("Check existence of object %s in container %s", objectName, containerName));
        String bucketName = this.generateBucketName(containerName);
        try {
            return this.client.doesObjectExist(bucketName, objectName);
        }
        catch (SdkBaseException e) {
            LOGGER.debug(String.format("Error when trying to check existence of object %s in container %s. Reason: errorMessage=%s", objectName, containerName, e.getMessage()), (Throwable)e);
            throw new ContentAddressableStorageServerException("Error when trying to check existence of object", (Throwable)e);
        }
    }

    @Override
    public String getObjectDigest(String containerName, String objectName, DigestType digestType, boolean noCache) throws ContentAddressableStorageException {
        LOGGER.debug(String.format("Get digest of object %s in container %s", objectName, containerName));
        if (!noCache) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            String bucketName = this.generateBucketName(containerName);
            try {
                GetObjectMetadataRequest getObjectMetadataRequest = new GetObjectMetadataRequest(bucketName, objectName);
                ObjectMetadata objectMetadata = this.client.getObjectMetadata(getObjectMetadataRequest);
                PerformanceLogger.getInstance().log("STP_Offer_" + this.getConfiguration().getProvider(), containerName, "READ_DIGEST_FROM_METADATA", stopwatch.elapsed(TimeUnit.MILLISECONDS));
                return this.getDigestFromObjectMetadata(containerName, objectName, digestType, bucketName, objectMetadata);
            }
            catch (AmazonServiceException e) {
                LOGGER.debug(String.format("Error when trying to compute digest of object %s from container %s. Reason: errorCode=%s, errorType=%s, errorMessage=%s", objectName, containerName, e.getErrorCode(), e.getErrorType(), e.getErrorMessage()), (Throwable)e);
                if (AmazonS3APIErrorCodes.NOT_FOUND.getErrorCode().equals(e.getErrorCode())) {
                    throw new ContentAddressableStorageNotFoundException(ErrorMessage.OBJECT_NOT_FOUND.getMessage() + objectName, (Throwable)e);
                }
                throw new ContentAddressableStorageServerException("Error when trying to compute digest of object", (Throwable)e);
            }
            catch (SdkBaseException e) {
                LOGGER.debug(String.format("Error when trying to compute digest of object %s from container %s. Reason: errorMessage=%s", objectName, containerName, e.getMessage()), (Throwable)e);
                throw new ContentAddressableStorageServerException("Error when trying to compute digest of object", (Throwable)e);
            }
        }
        return this.computeObjectDigest(containerName, objectName, digestType);
    }

    private String getDigestFromObjectMetadata(String containerName, String objectName, DigestType digestType, String bucketName, ObjectMetadata objectMetadata) throws ContentAddressableStorageException {
        if (null != objectMetadata && objectMetadata.getUserMetadata().containsKey(X_OBJECT_META_DIGEST) && objectMetadata.getUserMetadata().containsKey(X_OBJECT_META_DIGEST_TYPE) && digestType.getName().equals(objectMetadata.getUserMetadata().get(X_OBJECT_META_DIGEST_TYPE)) && null != objectMetadata.getUserMetadata().get(X_OBJECT_META_DIGEST)) {
            return (String)objectMetadata.getUserMetadata().get(X_OBJECT_META_DIGEST);
        }
        LOGGER.warn(String.format("Could not retrieve cached digest of object '%s' in container '%s'. Recomputing digest", objectName, containerName));
        Pair<String, Long> objectDigestAndSize = this.computeObjectDigestAndSize(containerName, objectName, digestType);
        String digestToStore = (String)objectDigestAndSize.getKey();
        Long objectSize = (Long)objectDigestAndSize.getValue();
        this.storeDigest(containerName, objectName, digestType, digestToStore, bucketName, objectSize);
        return digestToStore;
    }

    @Override
    public ContainerInformation getContainerInformation(String containerName) throws ContentAddressableStorageNotFoundException, ContentAddressableStorageServerException {
        LOGGER.debug(String.format("Get information of container %s", containerName));
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_NAME_IS_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName});
        ContainerInformation containerInformation = new ContainerInformation();
        containerInformation.setUsableSpace(-1L);
        return containerInformation;
    }

    @Override
    public MetadatasObject getObjectMetadata(String containerName, String objectId, boolean noCache) throws ContentAddressableStorageException {
        LOGGER.debug(String.format("Get metadata of object %s in container %s", objectId, containerName));
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_OBJECT_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, objectId});
        String bucketName = this.generateBucketName(containerName);
        try {
            MetadatasStorageObject result = new MetadatasStorageObject();
            GetObjectMetadataRequest getObjectMetadataRequest = new GetObjectMetadataRequest(bucketName, objectId);
            ObjectMetadata objectMetadata = this.client.getObjectMetadata(getObjectMetadataRequest);
            result.setType(containerName.split("_")[1]);
            result.setObjectName(objectId);
            result.setDigest(noCache ? this.computeObjectDigest(containerName, objectId, VitamConfiguration.getDefaultDigestType()) : this.getDigestFromObjectMetadata(containerName, objectId, VitamConfiguration.getDefaultDigestType(), bucketName, objectMetadata));
            result.setFileSize(objectMetadata.getContentLength());
            result.setLastModifiedDate(objectMetadata.getLastModified().toString());
            return result;
        }
        catch (AmazonServiceException e) {
            LOGGER.debug(String.format("Error when trying to get metadata of object %s in container %s. Reason: errorCode=%s, errorType=%s, errorMessage=%s", objectId, containerName, e.getErrorCode(), e.getErrorType(), e.getErrorMessage()), (Throwable)e);
            if (AmazonS3APIErrorCodes.NOT_FOUND.getErrorCode().equals(e.getErrorCode())) {
                throw new ContentAddressableStorageNotFoundException(ErrorMessage.OBJECT_NOT_FOUND.getMessage() + objectId, (Throwable)e);
            }
            throw new ContentAddressableStorageServerException("Error when trying to get metadata of object", (Throwable)e);
        }
        catch (SdkBaseException e) {
            LOGGER.debug(String.format("Error when trying to get metadata of object %s in container %s. Reason: errorMessage=%s", objectId, containerName, e.getMessage()), (Throwable)e);
            throw new ContentAddressableStorageServerException("Error when trying to get metadata of object", (Throwable)e);
        }
    }

    @Override
    public void listContainer(String containerName, ObjectListingListener objectListingListener) throws ContentAddressableStorageNotFoundException, ContentAddressableStorageServerException, IOException {
        LOGGER.debug(String.format("Listing of object in container %s", containerName));
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_NAME_IS_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName});
        String bucketName = this.generateBucketName(containerName);
        try {
            ListObjectsV2Result listObjectsV2Result;
            String continuationToken = null;
            do {
                ListObjectsV2Request listObjectsV2Request = new ListObjectsV2Request();
                listObjectsV2Request.setBucketName(bucketName);
                listObjectsV2Request.setMaxKeys(Integer.valueOf(this.getConfiguration().getS3ListObjectBulkSize()));
                listObjectsV2Request.setContinuationToken(continuationToken);
                listObjectsV2Result = this.client.listObjectsV2(listObjectsV2Request);
                for (S3ObjectSummary objectSummary : listObjectsV2Result.getObjectSummaries()) {
                    objectListingListener.handleObjectEntry(new ObjectEntry(objectSummary.getKey(), objectSummary.getSize()));
                }
            } while ((continuationToken = listObjectsV2Result.getNextContinuationToken()) != null);
        }
        catch (AmazonServiceException e) {
            LOGGER.debug(String.format("Error when trying to list objects from container %s. Reason: errorCode=%s, errorType=%s, errorMessage=%s", containerName, e.getErrorCode(), e.getErrorType(), e.getErrorMessage()), (Throwable)e);
            if (AmazonS3APIErrorCodes.NO_SUCH_BUCKET.getErrorCode().equals(e.getErrorCode())) {
                throw new ContentAddressableStorageNotFoundException(ErrorMessage.CONTAINER_NOT_FOUND.getMessage() + containerName, (Throwable)e);
            }
            throw new ContentAddressableStorageServerException("Error when trying to list objects", (Throwable)e);
        }
        catch (SdkBaseException e) {
            LOGGER.debug(String.format("Error when trying to list objects from container %s. Reason: errorMessage=%s", containerName, e.getMessage()), (Throwable)e);
            throw new ContentAddressableStorageServerException("Error when trying to list objects", (Throwable)e);
        }
    }

    public void close() {
    }

    public String generateBucketName(String containerName) {
        String bucketName = containerName.replaceAll("[^A-Za-z0-9]", ".").toLowerCase();
        bucketName = StringUtils.strip((String)bucketName, (String)".");
        LOGGER.debug(String.format("Generated bucket name %s from container name %s", bucketName, containerName));
        BucketNameUtils.validateBucketName((String)bucketName);
        return bucketName;
    }

    private boolean useMultipartUpload(long size) {
        return !this.s3DisableMultipartUpload && size > this.s3MaxUploadPartSize;
    }
}

