db = db.getSiblingDB('metadata');
// Load the schema
var schema = JSON.parse(fs.readFileSync("/vitam/script/mongos/archive-unit-schema.json"));

function normalizeSchema(schema) {
    // pas de $schema
    delete schema.$schema

    // Replace "$ref" references by inline definitions
    const definitions = schema.definitions
    delete schema.definitions

    let def_re = RegExp("#/definitions/(.*)")

    function resolveRef(schema) {

        if ("$ref" in schema) {
            let ref = def_re.exec(schema.$ref)[1]

            delete schema.$ref

            let def = definitions[ref]
            for (let item in def) {
                schema[item] = def[item]
            }

            // recursive replace
            resolveRef(schema);
        }

        if (schema.type === "integer") {
            delete schema.type
            schema.type = "number"
        }

        if (schema.format === 'date-time-vitam') {
            delete schema.format // les dates sont réputés correctes, il n'y a pas eu de changement
        }

        for (let itemName in schema) {
            const item = schema[itemName]
            if (typeof item == "object") {
                resolveRef(item)
            }
        }
    }

    resolveRef(schema)
}

normalizeSchema(schema)

var result = db.Unit.find(
    {
        $jsonSchema: {not: schema}
    },
    {
        _id: true, _tenant: true,
        Title: true
    }
    ).toArray();

print("Number of invalid Units: " + result.length)

// Map the array elements to JSON strings
result = result.map(e => JSON.stringify(e));

print(result.join("\n"))
