/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.security.server.context.service;

import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.ServicesData;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.exception.NotFoundException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.mongo.service.SequenceGeneratorService;
import fr.gouv.vitamui.commons.mongo.service.VitamUICrudService;
import fr.gouv.vitamui.security.common.dto.ContextDto;
import fr.gouv.vitamui.security.server.certificate.dao.CertificateRepository;
import fr.gouv.vitamui.security.server.certificate.domain.Certificate;
import fr.gouv.vitamui.security.server.context.dao.ContextRepository;
import fr.gouv.vitamui.security.server.context.domain.Context;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class ContextService
extends VitamUICrudService<ContextDto, Context> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ContextService.class);
    private final ContextRepository contextRepository;
    private final CertificateRepository certificateRepository;

    @Autowired
    public ContextService(SequenceGeneratorService sequenceGeneratorService, ContextRepository contextRepository, CertificateRepository certificateRepository) {
        super(sequenceGeneratorService);
        this.contextRepository = contextRepository;
        this.certificateRepository = certificateRepository;
    }

    public ContextDto findByCertificate(String data) {
        Certificate certificate = this.certificateRepository.findByData(data);
        if (certificate == null) {
            LOGGER.error("the certificate is not found");
            throw new NotFoundException("Certificate not found");
        }
        String contextId = certificate.getContextId();
        List contexts = this.getMany(new String[]{contextId});
        if (contexts == null) {
            LOGGER.debug("Certificate not found");
            throw new InternalServerException("No context was found with id: " + certificate.getContextId());
        }
        if (contexts.size() != 1) {
            LOGGER.debug("Unable to find only one context for certificate");
            throw new InternalServerException("Unable to find only one context with id " + certificate.getContextId() + " for certificate");
        }
        return (ContextDto)contexts.get(0);
    }

    public ContextDto addTenant(String contextId, Integer tenantIdentifier) {
        ContextDto contextDto = (ContextDto)this.getOne(contextId, Optional.empty(), Optional.empty());
        if (contextDto == null) {
            LOGGER.error("the Context is not found");
            throw new NotFoundException("Context not found");
        }
        contextDto.getTenants().add(tenantIdentifier);
        return (ContextDto)this.update((IdDto)contextDto);
    }

    protected void beforeCreate(ContextDto dto) {
        super.beforeCreate((IdDto)dto);
        List roleNames = dto.getRoleNames();
        Assert.isTrue((boolean)ServicesData.checkIfRoleNameExists((List)roleNames), (String)("Some of the rolenames: " + roleNames + " are not allowed"));
    }

    protected void beforeUpdate(ContextDto dto) {
        super.beforeUpdate((IdDto)dto);
        List roleNames = dto.getRoleNames();
        Assert.isTrue((boolean)ServicesData.checkIfRoleNameExists((List)roleNames), (String)("Some of the rolenames: " + roleNames + " are not allowed"));
    }

    protected Context internalConvertFromDtoToEntity(ContextDto dto) {
        Context context = new Context();
        context.setId(dto.getId());
        context.setName(dto.getName());
        context.setFullAccess(dto.isFullAccess());
        context.setTenants(dto.getTenants());
        context.setRoleNames(dto.getRoleNames());
        return context;
    }

    protected ContextDto internalConvertFromEntityToDto(Context context) {
        ContextDto dto = new ContextDto();
        dto.setId(context.getId());
        dto.setName(context.getName());
        dto.setFullAccess(context.isFullAccess());
        dto.setTenants(context.getTenants());
        dto.setRoleNames(context.getRoleNames());
        return dto;
    }

    protected ContextRepository getRepository() {
        return this.contextRepository;
    }

    protected String getObjectName() {
        return "context";
    }

    protected Class<Context> getEntityClass() {
        return Context.class;
    }

    @Generated
    public ContextRepository getContextRepository() {
        return this.contextRepository;
    }

    @Generated
    public CertificateRepository getCertificateRepository() {
        return this.certificateRepository;
    }
}

