/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.pastis.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.pastis.common.dto.ElementProperties;
import fr.gouv.vitamui.pastis.common.dto.jaxb.AnnotationXML;
import fr.gouv.vitamui.pastis.common.dto.jaxb.AnyNameXML;
import fr.gouv.vitamui.pastis.common.dto.jaxb.AttributeXML;
import fr.gouv.vitamui.pastis.common.dto.jaxb.BaliseXML;
import fr.gouv.vitamui.pastis.common.dto.jaxb.ChoiceXml;
import fr.gouv.vitamui.pastis.common.dto.jaxb.DataXML;
import fr.gouv.vitamui.pastis.common.dto.jaxb.DocumentationXML;
import fr.gouv.vitamui.pastis.common.dto.jaxb.ElementXML;
import fr.gouv.vitamui.pastis.common.dto.jaxb.ExceptXML;
import fr.gouv.vitamui.pastis.common.dto.jaxb.GrammarXML;
import fr.gouv.vitamui.pastis.common.dto.jaxb.NsNameXML;
import fr.gouv.vitamui.pastis.common.dto.jaxb.OneOrMoreXML;
import fr.gouv.vitamui.pastis.common.dto.jaxb.OptionalXML;
import fr.gouv.vitamui.pastis.common.dto.jaxb.StartXML;
import fr.gouv.vitamui.pastis.common.dto.jaxb.ValueXML;
import fr.gouv.vitamui.pastis.common.dto.jaxb.ZeroOrMoreXML;
import fr.gouv.vitamui.pastis.common.dto.profiles.Notice;
import fr.gouv.vitamui.pastis.common.dto.profiles.PastisProfile;
import fr.gouv.vitamui.pastis.common.dto.profiles.ProfileNotice;
import fr.gouv.vitamui.pastis.common.dto.profiles.ProfileResponse;
import fr.gouv.vitamui.pastis.common.dto.profiles.ProfileType;
import fr.gouv.vitamui.pastis.common.exception.TechnicalException;
import fr.gouv.vitamui.pastis.common.service.JsonFromPUA;
import fr.gouv.vitamui.pastis.common.service.PuaFromJSON;
import fr.gouv.vitamui.pastis.common.service.PuaPastisValidator;
import fr.gouv.vitamui.pastis.common.util.NoticeUtils;
import fr.gouv.vitamui.pastis.common.util.PastisCustomCharacterEscapeHandler;
import fr.gouv.vitamui.pastis.common.util.PastisGetXmlJsonTree;
import fr.gouv.vitamui.pastis.common.util.PastisSAX2Handler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import lombok.Generated;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

@Service
public class PastisService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(PastisService.class);
    private static final String APPLICATION_JSON_UTF8 = "application/json; charset=utf-8";
    private final ResourceLoader resourceLoader;
    @Value(value="${rng.base.file}")
    private String rngFile;
    @Value(value="${json.template.fileStandalone}")
    private String jsonFileStandalone;
    @Value(value="${json.template.fileVitam}")
    private String jsonFileVitam;
    @Value(value="${rng.base.directory}")
    private String rngLocation;
    private final PuaPastisValidator puaPastisValidator;
    private final JsonFromPUA jsonFromPUA;
    private final PuaFromJSON puaFromJSON;
    private List<PastisProfile> pastisProfiles = new ArrayList<PastisProfile>();
    private List<Notice> notices = new ArrayList<Notice>();
    private Random rand;

    @Autowired
    public PastisService(ResourceLoader resourceLoader, PuaPastisValidator puaPastisValidator, JsonFromPUA jsonFromPUA, PuaFromJSON puaFromJSON) {
        this.resourceLoader = resourceLoader;
        this.puaPastisValidator = puaPastisValidator;
        this.jsonFromPUA = jsonFromPUA;
        this.puaFromJSON = puaFromJSON;
    }

    public String getArchiveProfile(ElementProperties json) throws TechnicalException {
        String response;
        json.initTree(json);
        BaliseXML.buildBaliseXMLTree((ElementProperties)json, (int)0, null);
        BaliseXML.addRecipTags();
        BaliseXML eparentRng = BaliseXML.getBaliseXMLStatic();
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);){
            JAXBContext contextObj = JAXBContext.newInstance((Class[])new Class[]{AttributeXML.class, ElementXML.class, DataXML.class, ValueXML.class, OptionalXML.class, OneOrMoreXML.class, ZeroOrMoreXML.class, AnnotationXML.class, DocumentationXML.class, StartXML.class, GrammarXML.class, ChoiceXml.class, AnyNameXML.class, ExceptXML.class, NsNameXML.class});
            Marshaller marshallerObj = contextObj.createMarshaller();
            marshallerObj.setProperty("jaxb.formatted.output", (Object)true);
            marshallerObj.setProperty("com.sun.xml.bind.marshaller.CharacterEscapeHandler", (Object)new PastisCustomCharacterEscapeHandler());
            marshallerObj.marshal((Object)eparentRng, (Writer)writer);
            response = os.toString(StandardCharsets.UTF_8);
        }
        catch (IOException | JAXBException e) {
            throw new TechnicalException("Failure RNG Profile could not be generated", e);
        }
        LOGGER.debug("RNG profile generated successfully");
        return response;
    }

    public String getArchiveUnitProfile(ProfileNotice json, boolean standalone) throws TechnicalException {
        String controlSchema;
        Notice notice = new Notice();
        if (!standalone && json.getNotice() != null) {
            notice = json.getNotice();
        }
        try {
            controlSchema = this.puaFromJSON.getControlSchemaFromElementProperties(json.getElementProperties());
        }
        catch (IOException e) {
            throw new TechnicalException("Problems when deserializing using Jackson with Element Properties of AUP json to have ControlsShema", (Throwable)e);
        }
        notice.setControlSchema(controlSchema);
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)notice);
        }
        catch (JsonProcessingException e) {
            throw new TechnicalException("Problems during conversion objectMapper to string", (Throwable)e);
        }
    }

    public Resource getFile(String filename) {
        return new ClassPathResource(this.rngLocation + filename + ".rng");
    }

    public ProfileResponse createProfile(String type, boolean standalone) throws TechnicalException, NoSuchAlgorithmException {
        ProfileResponse profileResponse = null;
        if (type != null && !type.isEmpty()) {
            ProfileType profileType = ProfileType.valueOf((String)type);
            ClassPathResource resource = type.equals(ProfileType.PA.getType()) ? new ClassPathResource(this.rngFile) : (standalone ? new ClassPathResource(this.jsonFileStandalone) : new ClassPathResource(this.jsonFileVitam));
            profileResponse = this.createProfileByType((Resource)resource, profileType);
        }
        return profileResponse;
    }

    public ProfileResponse loadProfile(Notice notice) throws TechnicalException {
        PastisSAX2Handler handler = new PastisSAX2Handler();
        PastisGetXmlJsonTree getJson = new PastisGetXmlJsonTree();
        ProfileResponse profileResponse = new ProfileResponse();
        ProfileType fileType = NoticeUtils.getFileType((Notice)notice);
        try {
            profileResponse.setId(notice.getId());
            profileResponse.setType(fileType);
            profileResponse.setName(notice.getIdentifier());
            String s = notice.serialiseString();
            JSONObject profileJson = new JSONObject(s);
            if (fileType.equals((Object)ProfileType.PA)) {
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(this.rngLocation + notice.getPath());
                InputSource inputSource = new InputSource(inputStream);
                XMLReader xmlReader = this.createXmlReader(handler);
                xmlReader.parse(inputSource);
                profileResponse.setProfile(getJson.getJsonParsedTree(handler.getElementRNGRoot()));
                LOGGER.info("Starting editing Archive Profile with id : {}", (Object)notice.getId());
            } else if (fileType.equals((Object)ProfileType.PUA)) {
                this.puaPastisValidator.validatePUA(profileJson, false);
                profileResponse.setProfile(this.jsonFromPUA.getProfileFromPUA(profileJson));
            }
            profileResponse.setNotice(NoticeUtils.getNoticeFromPUA((JSONObject)profileJson));
        }
        catch (IOException | SAXException e) {
            throw new TechnicalException("Failed to load profile with id " + notice.getId(), (Throwable)e);
        }
        catch (AssertionError ae) {
            throw new TechnicalException("Failed to load pua with id" + notice.getId(), (Throwable)((Object)ae));
        }
        return profileResponse;
    }

    public ElementProperties loadProfilePA(Resource resource) {
        try {
            return this.loadProfilePA(resource.getInputStream());
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
            return null;
        }
    }

    public ElementProperties loadProfilePA(MultipartFile file) {
        try {
            return this.loadProfilePA(file.getInputStream());
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
            return null;
        }
    }

    public ElementProperties loadProfilePA(InputStream inputStream) {
        ElementProperties elementProperties;
        PastisSAX2Handler handler = new PastisSAX2Handler();
        PastisGetXmlJsonTree getJson = new PastisGetXmlJsonTree();
        try {
            InputSource inputSource = new InputSource(inputStream);
            XMLReader xmlReader = this.createXmlReader(handler);
            xmlReader.parse(inputSource);
            elementProperties = getJson.getJsonParsedTree(handler.getElementRNGRoot());
        }
        catch (IOException | SAXException e) {
            LOGGER.error(e.getMessage());
            return null;
        }
        return elementProperties;
    }

    private XMLReader createXmlReader(PastisSAX2Handler handler) throws SAXException {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        xmlReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        xmlReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        xmlReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        xmlReader.setContentHandler((ContentHandler)handler);
        return xmlReader;
    }

    public ProfileResponse createProfileByType(Resource resource, ProfileType profileType) throws TechnicalException, NoSuchAlgorithmException {
        PastisSAX2Handler handler = new PastisSAX2Handler();
        PastisGetXmlJsonTree getJson = new PastisGetXmlJsonTree();
        ProfileResponse profileResponse = new ProfileResponse();
        this.rand = SecureRandom.getInstanceStrong();
        try {
            profileResponse.setType(profileType);
            profileResponse.setName(resource.getFilename());
            InputStream fileInputStream = resource.getInputStream();
            InputSource inputSource = new InputSource(resource.getInputStream());
            if (profileType.equals((Object)ProfileType.PA)) {
                XMLReader xmlReader = this.createXmlReader(handler);
                xmlReader.parse(inputSource);
                profileResponse.setProfile(getJson.getJsonParsedTree(handler.getElementRNGRoot()));
                LOGGER.info("Starting editing Archive Profile from file : {}", (Object)resource.getFilename());
            } else {
                JSONTokener tokener = new JSONTokener((Reader)new InputStreamReader(fileInputStream));
                JSONObject profileJson = new JSONObject(tokener);
                this.puaPastisValidator.validatePUA(profileJson, false);
                profileResponse.setProfile(this.jsonFromPUA.getProfileFromPUA(profileJson));
                profileResponse.setNotice(NoticeUtils.getNoticeFromPUA((JSONObject)profileJson));
                LOGGER.info("Starting editing Archive Unit Profile with name : {}", (Object)resource.getFilename());
            }
        }
        catch (IOException | SAXException e) {
            throw new TechnicalException("Failed to load profile ", (Throwable)e);
        }
        catch (AssertionError ae) {
            throw new TechnicalException("Failed to load pua ", (Throwable)((Object)ae));
        }
        return profileResponse;
    }

    public ProfileResponse loadProfileFromFile(MultipartFile file, String fileName, boolean standalone) throws NoSuchAlgorithmException, TechnicalException {
        PastisSAX2Handler handler = new PastisSAX2Handler();
        PastisGetXmlJsonTree getJson = new PastisGetXmlJsonTree();
        ProfileResponse profileResponse = new ProfileResponse();
        this.rand = SecureRandom.getInstanceStrong();
        try {
            String originalFileName = fileName;
            if (originalFileName != null) {
                String fileExtension = originalFileName.split("\\.")[1];
                String profileName = originalFileName.split("\\.(?=[^\\.]+$)")[0];
                profileResponse.setType(fileExtension.equals("rng") ? ProfileType.PA : ProfileType.PUA);
                profileResponse.setName(profileName);
            }
            InputStream fileInputStream = file.getInputStream();
            InputSource inputSource = new InputSource(file.getInputStream());
            if (profileResponse.getType().equals((Object)ProfileType.PA)) {
                XMLReader xmlReader = this.createXmlReader(handler);
                xmlReader.parse(inputSource);
                profileResponse.setProfile(getJson.getJsonParsedTree(handler.getElementRNGRoot()));
                LOGGER.info("Starting editing Archive Profile from file : {}", (Object)fileName);
            } else {
                JSONTokener tokener = new JSONTokener((Reader)new InputStreamReader(fileInputStream));
                JSONObject profileJson = new JSONObject(tokener);
                this.puaPastisValidator.validatePUA(profileJson, standalone);
                profileResponse.setProfile(this.jsonFromPUA.getProfileFromPUA(profileJson));
                profileResponse.setNotice(NoticeUtils.getNoticeFromPUA((JSONObject)profileJson));
                LOGGER.info("Starting editing Archive Unit Profile with name : {}", (Object)file.getOriginalFilename());
            }
        }
        catch (IOException | SAXException e) {
            throw new TechnicalException("Failed to load profile " + fileName, (Throwable)e);
        }
        catch (AssertionError ae) {
            throw new TechnicalException("Failed to load pua ", (Throwable)((Object)ae));
        }
        return profileResponse;
    }

    public List<Notice> getFiles() throws TechnicalException {
        try {
            Resource[] resources = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader).getResources("classpath*:" + this.rngLocation + "*.*");
            if (this.notices.isEmpty()) {
                for (Resource r : resources) {
                    this.notices.add(new Notice(r));
                }
            }
        }
        catch (IOException e) {
            throw new TechnicalException("Resource Loader could not retrieve resource", (Throwable)e);
        }
        return this.notices;
    }

    @Generated
    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Generated
    public String getRngFile() {
        return this.rngFile;
    }

    @Generated
    public String getJsonFileStandalone() {
        return this.jsonFileStandalone;
    }

    @Generated
    public String getJsonFileVitam() {
        return this.jsonFileVitam;
    }

    @Generated
    public String getRngLocation() {
        return this.rngLocation;
    }

    @Generated
    public PuaPastisValidator getPuaPastisValidator() {
        return this.puaPastisValidator;
    }

    @Generated
    public JsonFromPUA getJsonFromPUA() {
        return this.jsonFromPUA;
    }

    @Generated
    public PuaFromJSON getPuaFromJSON() {
        return this.puaFromJSON;
    }

    @Generated
    public List<PastisProfile> getPastisProfiles() {
        return this.pastisProfiles;
    }

    @Generated
    public List<Notice> getNotices() {
        return this.notices;
    }

    @Generated
    public Random getRand() {
        return this.rand;
    }

    @Generated
    public void setRngFile(String rngFile) {
        this.rngFile = rngFile;
    }

    @Generated
    public void setJsonFileStandalone(String jsonFileStandalone) {
        this.jsonFileStandalone = jsonFileStandalone;
    }

    @Generated
    public void setJsonFileVitam(String jsonFileVitam) {
        this.jsonFileVitam = jsonFileVitam;
    }

    @Generated
    public void setRngLocation(String rngLocation) {
        this.rngLocation = rngLocation;
    }

    @Generated
    public void setPastisProfiles(List<PastisProfile> pastisProfiles) {
        this.pastisProfiles = pastisProfiles;
    }

    @Generated
    public void setNotices(List<Notice> notices) {
        this.notices = notices;
    }

    @Generated
    public void setRand(Random rand) {
        this.rand = rand;
    }
}

