/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.UserInfoDto;
import fr.gouv.vitamui.commons.api.exception.ForbiddenException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.iam.internal.client.UserInfoInternalRestClient;
import fr.gouv.vitamui.iam.security.client.AbstractResourceClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserInfoExternalService
extends AbstractResourceClientService<UserInfoDto, UserInfoDto> {
    private final UserInfoInternalRestClient userInfoInternalRestClient;

    @Autowired
    public UserInfoExternalService(UserInfoInternalRestClient userInfoInternalRestClient, ExternalSecurityService externalSecurityService) {
        super(externalSecurityService);
        this.userInfoInternalRestClient = userInfoInternalRestClient;
    }

    public UserInfoDto create(UserInfoDto userInfoDto) {
        return (UserInfoDto)super.create((IdDto)userInfoDto);
    }

    public UserInfoDto getOne(String id) {
        return (UserInfoDto)super.getOne(id);
    }

    public UserInfoDto getMe() {
        return this.userInfoInternalRestClient.getMe(this.getInternalHttpContext());
    }

    public UserInfoDto patchMe(Map<String, Object> partialDto) {
        AuthUserDto user = this.externalSecurityService.getUser();
        partialDto.put("id", user.getUserInfoId());
        return this.patch(partialDto);
    }

    public UserInfoDto patch(Map<String, Object> partialDto) {
        return (UserInfoDto)super.patch(partialDto);
    }

    protected String getVersionApiCrtieria() {
        return "v2";
    }

    protected UserInfoInternalRestClient getClient() {
        return this.userInfoInternalRestClient;
    }

    public LogbookOperationsResponseDto findHistoryById(String id) {
        this.checkLogbookRight(id);
        JsonNode body = this.getClient().findHistoryById((AbstractHttpContext)this.getInternalHttpContext(), id);
        try {
            return (LogbookOperationsResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    public void checkLogbookRight(String id) {
        boolean hasRoleGetUserInfos = this.externalSecurityService.hasRole("ROLE_GET_USER_INFOS");
        if (!hasRoleGetUserInfos && !StringUtils.equals((CharSequence)this.externalSecurityService.getUser().getUserInfoId(), (CharSequence)id)) {
            throw new ForbiddenException(String.format("Unable to access user info with id: %s", id));
        }
        UserInfoDto userInfoDto = (UserInfoDto)super.getOne(id);
        if (userInfoDto == null) {
            throw new ForbiddenException(String.format("Unable to access user info with id: %s", id));
        }
    }

    @Generated
    public UserInfoInternalRestClient getUserInfoInternalRestClient() {
        return this.userInfoInternalRestClient;
    }
}

