/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.commons.api.domain.Criterion;
import fr.gouv.vitamui.commons.api.domain.CriterionOperator;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.domain.QueryDto;
import fr.gouv.vitamui.commons.api.domain.QueryOperator;
import fr.gouv.vitamui.commons.api.domain.UserDto;
import fr.gouv.vitamui.commons.api.enums.UserTypeEnum;
import fr.gouv.vitamui.commons.api.exception.ForbiddenException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.exception.NotImplementedException;
import fr.gouv.vitamui.commons.api.utils.EnumUtils;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.iam.internal.client.UserInternalRestClient;
import fr.gouv.vitamui.iam.security.client.AbstractResourceClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class UserExternalService
extends AbstractResourceClientService<UserDto, UserDto> {
    private static final String TYPE_KEY = "type";
    private static final String LEVEL_KEY = "level";
    private final UserInternalRestClient userInternalRestClient;

    @Autowired
    public UserExternalService(UserInternalRestClient userInternalRestClient, ExternalSecurityService externalSecurityService) {
        super(externalSecurityService);
        this.userInternalRestClient = userInternalRestClient;
    }

    public UserDto create(UserDto dto) {
        this.checkCustomerId(dto.getCustomerId(), "Unable to create user");
        return (UserDto)super.create((IdDto)dto);
    }

    public UserDto update(UserDto dto) {
        this.checkCustomerId(dto.getCustomerId(), "Unable to update user");
        return (UserDto)super.update((IdDto)dto);
    }

    public UserDto patch(Map<String, Object> partialDto) {
        String customerId = (String)partialDto.get("customerId");
        if (StringUtils.isNotEmpty((CharSequence)customerId)) {
            this.checkCustomerId(customerId, "Unable to patch user");
        }
        partialDto.put("customerId", this.externalSecurityService.getCustomerId());
        return (UserDto)super.patch(partialDto);
    }

    public UserDto patchMe(Map<String, Object> partialDto) {
        AuthUserDto user = this.externalSecurityService.getUser();
        partialDto.put("id", user.getId());
        return this.patch(partialDto);
    }

    public boolean checkExists(String criteria) {
        return super.checkExists(criteria);
    }

    public UserDto getOne(String id) {
        return (UserDto)super.getOne(id);
    }

    public PaginatedValuesDto<UserDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        this.checkAllowedOrderby(orderBy);
        return super.getAllPaginated(page, size, criteria, orderBy, direction);
    }

    public Resource exportUsers(Optional<String> criteria) {
        return this.getClient().exportUsers(this.getInternalHttpContext(), this.checkAuthorization(criteria));
    }

    protected void addRestriction(String key, QueryDto query) {
        switch (key) {
            case "type": {
                this.addTypeRestriction(query);
                break;
            }
            case "level": {
                this.addLevelRestriction(query);
                break;
            }
            default: {
                throw new NotImplementedException("Restriction not defined for key: " + key);
            }
        }
    }

    private void checkAllowedOrderby(Optional<String> optOrderBy) {
        optOrderBy.ifPresent(orderBy -> {
            if (orderBy.trim().equalsIgnoreCase("password")) {
                throw new ForbiddenException("forbidden orderby field");
            }
        });
    }

    private void addLevelRestriction(QueryDto query) {
        QueryDto levelQuery = new QueryDto();
        levelQuery.setQueryOperator(QueryOperator.OR);
        levelQuery.addCriterion(LEVEL_KEY, (Object)(this.externalSecurityService.getLevel() + "."), CriterionOperator.STARTWITH);
        levelQuery.addCriterion("id", (Object)this.externalSecurityService.getUser().getId(), CriterionOperator.EQUALS);
        query.addQuery(levelQuery);
    }

    private void addTypeRestriction(QueryDto criteria) {
        Optional typeCriterion = criteria.find(TYPE_KEY);
        if (typeCriterion.isPresent()) {
            Criterion criterion = (Criterion)typeCriterion.get();
            UserTypeEnum userType = (UserTypeEnum)EnumUtils.stringToEnum(UserTypeEnum.class, (String)criterion.getValue().toString());
            if (!criterion.getOperator().equals((Object)CriterionOperator.EQUALS) || !userType.equals((Object)UserTypeEnum.NOMINATIVE)) {
                throw new ForbiddenException(String.format("User's type %s is not allowed", userType));
            }
        } else {
            criteria.addCriterion(new Criterion(TYPE_KEY, (Object)UserTypeEnum.NOMINATIVE, CriterionOperator.EQUALS));
        }
    }

    protected Collection<String> getAllowedKeys() {
        return Arrays.asList("id", "lastname", "firstname", "identifier", "groupId", "language", "email", "otp", "subrogeable", "phone", "mobile", "lastConnection", "status", LEVEL_KEY, TYPE_KEY, "customerId", "siteCode", "centerCodes");
    }

    protected Collection<String> getRestrictedKeys() {
        ArrayList<String> restrictedKeys = new ArrayList<String>(Arrays.asList("customerId", TYPE_KEY, LEVEL_KEY));
        if (this.externalSecurityService.hasRole("ROLE_GENERIC_USERS")) {
            restrictedKeys.remove(TYPE_KEY);
        }
        if (this.externalSecurityService.userIsRootLevel()) {
            restrictedKeys.remove(LEVEL_KEY);
        }
        return restrictedKeys;
    }

    protected Collection<String> getRestrictedKeys(QueryDto query) {
        Collection restrictedKeys = this.getRestrictedKeys();
        if (this.externalSecurityService.hasRole("ROLE_GET_USERS_ALL_CUSTOMERS")) {
            Optional<String> customerIdKey = query.getCriterionList().stream().map(Criterion::getKey).filter("customerId"::equals).findFirst();
            customerIdKey.ifPresent(customerId -> restrictedKeys.removeIf(customerId::equals));
        }
        return restrictedKeys;
    }

    protected String getVersionApiCrtieria() {
        return "v2";
    }

    protected UserInternalRestClient getClient() {
        return this.userInternalRestClient;
    }

    public LogbookOperationsResponseDto findHistoryById(String id) {
        this.checkLogbookRight(id);
        JsonNode body = this.getClient().findHistoryById((AbstractHttpContext)this.getInternalHttpContext(), id);
        try {
            return (LogbookOperationsResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    public void checkLogbookRight(String id) {
        boolean hasRoleGetUsers = this.externalSecurityService.hasRole("ROLE_GET_USERS");
        if (!hasRoleGetUsers && !StringUtils.equals((CharSequence)this.externalSecurityService.getUser().getId(), (CharSequence)id)) {
            throw new ForbiddenException(String.format("Unable to access user with id: %s", id));
        }
        UserDto usersDto = (UserDto)super.getOne(id);
        if (usersDto == null) {
            throw new ForbiddenException(String.format("Unable to access user with id: %s", id));
        }
    }

    public List<String> getLevels(Optional<String> criteria) {
        return this.getClient().getLevels(this.getInternalHttpContext(), this.checkAuthorization(criteria));
    }

    public UserDto patchAnalytics(Map<String, Object> partialDto) {
        boolean hasRolePatchUserAnalytics;
        if (partialDto.containsKey("id") && !(hasRolePatchUserAnalytics = this.externalSecurityService.hasRole("ROLE_UPDATE_USER_INFOS"))) {
            throw new ForbiddenException(String.format("Unable to patch analytics for user with id: %s", partialDto.get("id")));
        }
        return this.getClient().patchAnalytics(this.getInternalHttpContext(), partialDto);
    }

    @Generated
    public UserInternalRestClient getUserInternalRestClient() {
        return this.userInternalRestClient;
    }
}

