/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.server.service;

import fr.gouv.vitamui.commons.api.domain.CriterionOperator;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.GroupDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.domain.QueryDto;
import fr.gouv.vitamui.commons.api.domain.UserDto;
import fr.gouv.vitamui.commons.api.enums.UserTypeEnum;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.iam.common.dto.SubrogationDto;
import fr.gouv.vitamui.iam.common.dto.common.EmbeddedOptions;
import fr.gouv.vitamui.iam.internal.client.SubrogationInternalRestClient;
import fr.gouv.vitamui.iam.security.client.AbstractResourceClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SubrogationExternalService
extends AbstractResourceClientService<SubrogationDto, SubrogationDto> {
    private final SubrogationInternalRestClient subrogationInternalRestClient;

    @Autowired
    public SubrogationExternalService(ExternalSecurityService externalSecurityService, SubrogationInternalRestClient subrogationInternalRestClient) {
        super(externalSecurityService);
        this.subrogationInternalRestClient = subrogationInternalRestClient;
    }

    public List<SubrogationDto> getAll(Optional<String> criteria) {
        return super.getAll(criteria);
    }

    public SubrogationDto getOne(String id) {
        return (SubrogationDto)super.getOne(id);
    }

    public SubrogationDto create(SubrogationDto dto) {
        return (SubrogationDto)super.create((IdDto)dto);
    }

    public void decline(String id) {
        this.getClient().decline(this.getInternalHttpContext(), id);
    }

    public void delete(String id) {
        this.getClient().delete((AbstractHttpContext)this.getInternalHttpContext(), id);
    }

    public SubrogationDto accept(String id) {
        return this.getClient().accept(this.getInternalHttpContext(), id);
    }

    public SubrogationDto getMySubrogationAsSurrogate() {
        return this.getClient().getMySubrogationAsSurrogate(this.getInternalHttpContext());
    }

    public SubrogationDto getMySubrogationAsSuperuser() {
        return this.getClient().getMySubrogationAsSuperuser(this.getInternalHttpContext());
    }

    public PaginatedValuesDto<UserDto> getGenericUsers(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        QueryDto criteriaFiltered = QueryDto.fromJson(criteria);
        criteriaFiltered.addCriterion("type", (Object)UserTypeEnum.GENERIC, CriterionOperator.EQUALS);
        return this.getClient().getUsers(this.getInternalHttpContext(), page, size, criteriaFiltered.toOptionalJson(), orderBy, direction);
    }

    protected SubrogationInternalRestClient getClient() {
        return this.subrogationInternalRestClient;
    }

    protected Collection<String> getRestrictedKeys() {
        return CollectionUtils.emptyCollection();
    }

    protected Collection<String> getAllowedKeys() {
        return Arrays.asList("surrogateCustomerId");
    }

    protected String getVersionApiCrtieria() {
        return "v2";
    }

    public GroupDto getGroupById(String id) {
        return this.getClient().getGroupById(this.getInternalHttpContext(), id, Optional.of(EmbeddedOptions.ALL.toString()));
    }

    @Generated
    public SubrogationInternalRestClient getSubrogationInternalRestClient() {
        return this.subrogationInternalRestClient;
    }
}

