/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.commons.api.domain.CriterionOperator;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.domain.ProfileDto;
import fr.gouv.vitamui.commons.api.domain.QueryDto;
import fr.gouv.vitamui.commons.api.domain.QueryOperator;
import fr.gouv.vitamui.commons.api.exception.ForbiddenException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.exception.NotImplementedException;
import fr.gouv.vitamui.commons.api.utils.CastUtils;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.iam.internal.client.ProfileInternalRestClient;
import fr.gouv.vitamui.iam.security.client.AbstractResourceClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProfileExternalService
extends AbstractResourceClientService<ProfileDto, ProfileDto> {
    private final ProfileInternalRestClient profileInternalRestClient;

    @Autowired
    public ProfileExternalService(ProfileInternalRestClient profileInternalRestClient, ExternalSecurityService externalSecurityService) {
        super(externalSecurityService);
        this.profileInternalRestClient = profileInternalRestClient;
    }

    public ProfileDto create(ProfileDto dto) {
        this.checkCustomerId(dto.getCustomerId(), "Unable to create profile");
        this.checkTenantIdentifier(dto.getTenantIdentifier(), "Unable to create profile");
        return (ProfileDto)super.create((IdDto)dto);
    }

    public ProfileDto update(ProfileDto dto) {
        this.checkCustomerId(dto.getCustomerId(), "Unable to create profile");
        this.checkTenantIdentifier(dto.getTenantIdentifier(), "Unable to create profile");
        return (ProfileDto)super.update((IdDto)dto);
    }

    public ProfileDto patch(Map<String, Object> partialDto) {
        String customerId = CastUtils.toString((Object)partialDto.get("customerId"));
        Integer tenantIdentifier = CastUtils.toInteger((Object)partialDto.get("tenantIdentifier"));
        String level = CastUtils.toString((Object)partialDto.get("level"));
        if (StringUtils.isNotEmpty((CharSequence)customerId)) {
            this.checkCustomerId(customerId, "Unable to patch profile");
        }
        if (tenantIdentifier != null) {
            this.checkTenantIdentifier(tenantIdentifier, "Unable to patch profile");
        }
        if (StringUtils.isNotEmpty((CharSequence)level)) {
            this.checkLevel(level, "Unable to patch profile");
        }
        partialDto.put("customerId", this.externalSecurityService.getCustomerId());
        partialDto.put("tenantIdentifier", this.externalSecurityService.getTenantIdentifier());
        return (ProfileDto)super.patch(partialDto);
    }

    public boolean checkExists(String criteria) {
        return super.checkExists(criteria);
    }

    public ProfileDto getOne(String id, Optional<String> embedded) {
        return (ProfileDto)super.getOne(id, embedded);
    }

    public List<ProfileDto> getAll(Optional<String> criteria, Optional<String> embedded) {
        return super.getAll(criteria, embedded);
    }

    public PaginatedValuesDto<ProfileDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction, Optional<String> embedded) {
        return super.getAllPaginated(page, size, criteria, orderBy, direction, embedded);
    }

    protected Collection<String> getAllowedKeys() {
        return Arrays.asList("id", "applicationName", "name", "enabled", "description", "level", "tenantIdentifier", "customerId", "identifier", "externalParamId");
    }

    protected void addRestriction(String key, QueryDto query) {
        switch (key) {
            case "level": {
                this.addLevelRestriction(query);
                break;
            }
            default: {
                throw new NotImplementedException("Restriction not defined for key: " + key);
            }
        }
    }

    private void addLevelRestriction(QueryDto query) {
        QueryDto levelQuery = new QueryDto();
        levelQuery.setQueryOperator(QueryOperator.OR);
        levelQuery.addCriterion("level", (Object)(this.externalSecurityService.getLevel() + "."), CriterionOperator.STARTWITH);
        levelQuery.addCriterion("id", (Object)this.externalSecurityService.getUser().getProfileGroup().getProfileIds(), CriterionOperator.IN);
        query.addQuery(levelQuery);
    }

    protected Collection<String> getRestrictedKeys() {
        ArrayList<String> restrictedKeys = new ArrayList<String>(Arrays.asList("customerId", "level", "tenantIdentifier"));
        if (this.externalSecurityService.hasRole("ROLE_GET_PROFILES_ALL_TENANTS")) {
            restrictedKeys.remove("tenantIdentifier");
        }
        if (this.externalSecurityService.userIsRootLevel()) {
            restrictedKeys.remove("level");
        }
        return restrictedKeys;
    }

    protected ProfileInternalRestClient getClient() {
        return this.profileInternalRestClient;
    }

    protected String getVersionApiCrtieria() {
        return "v2";
    }

    public LogbookOperationsResponseDto findHistoryById(String id) {
        this.checkLogbookRight(id);
        JsonNode body = this.getClient().findHistoryById((AbstractHttpContext)this.getInternalHttpContext(), id);
        try {
            return (LogbookOperationsResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    public void checkLogbookRight(String id) {
        boolean hasRoleGetUsers = this.externalSecurityService.hasRole("ROLE_GET_PROFILES");
        if (!hasRoleGetUsers && !this.externalSecurityService.getUser().getProfileGroup().getProfileIds().contains(id)) {
            throw new ForbiddenException(String.format("Unable to access profile with id: %s", id));
        }
        ProfileDto profileDto = (ProfileDto)super.getOne(id);
        if (profileDto == null) {
            throw new ForbiddenException(String.format("Unable to access profile with id: %s", id));
        }
    }

    public List<String> getLevels(Optional<String> criteria) {
        return this.getClient().getLevels(this.getInternalHttpContext(), this.checkAuthorization(criteria));
    }

    @Generated
    public ProfileInternalRestClient getProfileInternalRestClient() {
        return this.profileInternalRestClient;
    }
}

