/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.OwnerDto;
import fr.gouv.vitamui.commons.api.exception.ForbiddenException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.iam.internal.client.OwnerInternalRestClient;
import fr.gouv.vitamui.iam.security.client.AbstractResourceClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OwnerExternalService
extends AbstractResourceClientService<OwnerDto, OwnerDto> {
    private final OwnerInternalRestClient ownerInternalRestClient;

    @Autowired
    public OwnerExternalService(OwnerInternalRestClient ownerInternalRestClient, ExternalSecurityService externalSecurityService) {
        super(externalSecurityService);
        this.ownerInternalRestClient = ownerInternalRestClient;
    }

    public LogbookOperationsResponseDto findHistoryById(String id) {
        this.checkLogbookRight(id);
        JsonNode body = this.getClient().findHistoryById((AbstractHttpContext)this.getInternalHttpContext(), id);
        try {
            return (LogbookOperationsResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    public void checkLogbookRight(String id) {
        OwnerDto ownerDto;
        boolean hasRoleGetOwner = this.externalSecurityService.hasRole("ROLE_GET_OWNERS");
        if (!hasRoleGetOwner) {
            // empty if block
        }
        if ((ownerDto = (OwnerDto)super.getOne(id)) == null) {
            throw new ForbiddenException(String.format("Unable to access owner with id: %s", id));
        }
    }

    public OwnerDto create(OwnerDto dto) {
        return (OwnerDto)super.create((IdDto)dto);
    }

    public OwnerDto update(OwnerDto dto) {
        return (OwnerDto)super.update((IdDto)dto);
    }

    public OwnerDto patch(Map<String, Object> partialDto) {
        return (OwnerDto)super.patch(partialDto);
    }

    public OwnerDto getOne(String id) {
        return (OwnerDto)super.getOne(id);
    }

    public boolean checkExists(String criteria) {
        return super.checkExists(criteria);
    }

    protected OwnerInternalRestClient getClient() {
        return this.ownerInternalRestClient;
    }

    protected Collection<String> getAllowedKeys() {
        return Arrays.asList("id", "name", "code", "companyName", "customerId");
    }

    protected Collection<String> getRestrictedKeys() {
        return Collections.emptyList();
    }

    protected String getVersionApiCrtieria() {
        return "v2";
    }

    @Generated
    public OwnerInternalRestClient getOwnerInternalRestClient() {
        return this.ownerInternalRestClient;
    }
}

