/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.exception.ApplicationServerException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.exception.NoRightsException;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BaseRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.rest.client.logbook.LogbookInternalRestClient;
import fr.gouv.vitamui.commons.rest.client.logbook.LogbookInternalWebClient;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookLifeCycleResponseDto;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.iam.security.client.AbstractInternalClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import java.util.Objects;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class LogbookExternalService
extends AbstractInternalClientService {
    private final LogbookInternalRestClient<InternalHttpContext> logbookRestClient;
    private final LogbookInternalWebClient<InternalHttpContext> logbookWebClient;

    @Autowired
    public LogbookExternalService(LogbookInternalRestClient<InternalHttpContext> logbookRestClient, ExternalSecurityService externalSecurityService, LogbookInternalWebClient<InternalHttpContext> logbookWebClient) {
        super(externalSecurityService);
        this.logbookRestClient = logbookRestClient;
        this.logbookWebClient = logbookWebClient;
    }

    public static <T> T responseMapping(JsonNode json, Class<T> clazz) {
        try {
            return (T)JsonUtils.treeToValue((JsonNode)json, clazz, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    protected void checkAccessRights(Integer requestedTenantIdentifier) {
        boolean allAccess = this.externalSecurityService.canAccessToAllTenants();
        if (!allAccess) {
            Integer tenantIdentifier = this.externalSecurityService.getTenantIdentifier();
            if (tenantIdentifier == null) {
                throw new ApplicationServerException("Unable to retrieve the tenant linked to the current user.");
            }
            if (!tenantIdentifier.equals(requestedTenantIdentifier) && !this.externalSecurityService.canAccessAllCustomersTenants()) {
                throw new NoRightsException("You can't access the operations on the following tenant : " + requestedTenantIdentifier);
            }
        }
    }

    public LogbookOperationsResponseDto findOperationByUnitId(@PathVariable String id) {
        return (LogbookOperationsResponseDto)LogbookExternalService.responseMapping((JsonNode)this.logbookRestClient.findOperationById((AbstractHttpContext)this.getInternalHttpContext(), id), LogbookOperationsResponseDto.class);
    }

    public LogbookLifeCycleResponseDto findUnitLifeCyclesByUnitId(@PathVariable String id) {
        return (LogbookLifeCycleResponseDto)LogbookExternalService.responseMapping((JsonNode)this.logbookRestClient.findUnitLifeCyclesByUnitId((AbstractHttpContext)this.getInternalHttpContext(), id), LogbookLifeCycleResponseDto.class);
    }

    public LogbookLifeCycleResponseDto findObjectGroupLifeCyclesByUnitId(@PathVariable String id) {
        return (LogbookLifeCycleResponseDto)LogbookExternalService.responseMapping((JsonNode)this.logbookRestClient.findObjectLifeCyclesByUnitId((AbstractHttpContext)this.getInternalHttpContext(), id), LogbookLifeCycleResponseDto.class);
    }

    public LogbookOperationsResponseDto findOperations(@RequestBody JsonNode select, Integer vitamTenantIdentifier) throws PreconditionFailedException {
        SanityChecker.sanitizeJson((JsonNode)select);
        if (Objects.nonNull(vitamTenantIdentifier)) {
            this.checkAccessRights(vitamTenantIdentifier);
        }
        return (LogbookOperationsResponseDto)LogbookExternalService.responseMapping((JsonNode)this.logbookRestClient.findOperations((AbstractHttpContext)this.getInternalHttpContext(), select, vitamTenantIdentifier), LogbookOperationsResponseDto.class);
    }

    public ResponseEntity<Resource> downloadManifest(String id) {
        return this.logbookRestClient.downloadManifest((AbstractHttpContext)this.getInternalHttpContext(), id);
    }

    public ResponseEntity<Resource> downloadAtr(String id) {
        return this.logbookRestClient.downloadAtr((AbstractHttpContext)this.getInternalHttpContext(), id);
    }

    public Mono<ResponseEntity<Resource>> downloadReport(String id, String downloadType) {
        return this.logbookWebClient.downloadReport((AbstractHttpContext)this.getInternalHttpContext(), id, downloadType);
    }

    protected BaseRestClient<InternalHttpContext> getClient() {
        return this.logbookRestClient;
    }

    @Generated
    public LogbookInternalRestClient<InternalHttpContext> getLogbookRestClient() {
        return this.logbookRestClient;
    }

    @Generated
    public LogbookInternalWebClient<InternalHttpContext> getLogbookWebClient() {
        return this.logbookWebClient;
    }
}

