/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.server.security;

import fr.gouv.vitamui.commons.rest.RestExceptionHandler;
import fr.gouv.vitamui.commons.security.client.logout.CasLogoutUrl;
import fr.gouv.vitamui.iam.security.config.ExternalApiWebSecurityConfig;
import fr.gouv.vitamui.iam.security.provider.ExternalApiAuthenticationProvider;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;

@EnableWebSecurity
@Configuration
@EnableGlobalMethodSecurity(securedEnabled=true, proxyTargetClass=true)
public class WebSecurityConfig
extends ExternalApiWebSecurityConfig {
    private static final String LOGOUT_ENDPOINT = "logout";
    @Value(value="${cas.external-url}")
    @NotNull
    private String casExternalUrl;

    public WebSecurityConfig(ExternalApiAuthenticationProvider apiAuthenticationProvider, RestExceptionHandler restExceptionHandler, Environment env) {
        super((AuthenticationProvider)apiAuthenticationProvider, restExceptionHandler, env);
    }

    @Bean
    public CasLogoutUrl casLogoutUrl() {
        String casLogoutUrl = this.casExternalUrl.endsWith("/") ? this.casExternalUrl + LOGOUT_ENDPOINT : this.casExternalUrl + "/logout";
        return new CasLogoutUrl(casLogoutUrl);
    }
}

