/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.domain.UserInfoDto;
import fr.gouv.vitamui.commons.api.exception.NotImplementedException;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.CrudController;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.iam.external.server.service.UserInfoExternalService;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/userinfos"})
public class UserInfoExternalController
implements CrudController<UserInfoDto> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(UserInfoExternalController.class);
    private final UserInfoExternalService userInfoExternalService;

    @Autowired
    public UserInfoExternalController(UserInfoExternalService userInfoExternalService) {
        this.userInfoExternalService = userInfoExternalService;
    }

    @PostMapping
    @Secured(value={"ROLE_CREATE_USER_INFOS"})
    public UserInfoDto create(@Valid @RequestBody UserInfoDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Create {}", (Object)dto);
        return this.userInfoExternalService.create(dto);
    }

    public UserInfoDto update(String id, UserInfoDto dto) {
        throw new NotImplementedException("update not supported");
    }

    public void delete(String id) {
        throw new NotImplementedException("delete not supported");
    }

    public Collection<UserInfoDto> getAll(Optional<String> criteria) {
        throw new NotImplementedException("getAll not supported");
    }

    public ResponseEntity<Void> checkExist(String criteria) {
        throw new NotImplementedException("checkExist not supported");
    }

    @GetMapping(value={"/{id}"})
    @Secured(value={"ROLE_GET_USER_INFOS"})
    public UserInfoDto getOne(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Get {}", (Object)id);
        return this.userInfoExternalService.getOne(id);
    }

    @GetMapping(value={"/me"})
    public UserInfoDto getMe() {
        LOGGER.debug("getMe {}");
        return this.userInfoExternalService.getMe();
    }

    @PatchMapping(value={"/me"})
    public UserInfoDto patchMe(@RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria(partialDto);
        LOGGER.debug("Patch me with {}", partialDto);
        return this.userInfoExternalService.patchMe(partialDto);
    }

    @PatchMapping(value={"/{id}"})
    @Secured(value={"ROLE_UPDATE_USER_INFOS"})
    public UserInfoDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria(partialDto);
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Patch User {} with {}", (Object)id, partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"Unable to patch user : the DTO id must match the path id");
        return this.userInfoExternalService.patch(partialDto);
    }

    @GetMapping(value={"/{id}/history"})
    public LogbookOperationsResponseDto findHistoryById(@PathVariable(value="id") String id) {
        LOGGER.debug("get logbook for user info with id :{}", (Object)id);
        return this.userInfoExternalService.findHistoryById(id);
    }

    @Generated
    public UserInfoExternalService getUserInfoExternalService() {
        return this.userInfoExternalService;
    }
}

