/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.domain.UserDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.CrudController;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.iam.external.server.service.UserExternalService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/users"})
public class UserExternalController
implements CrudController<UserDto> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(UserExternalController.class);
    private final UserExternalService userExternalService;

    @Autowired
    public UserExternalController(UserExternalService userService) {
        this.userExternalService = userService;
    }

    @Secured(value={"ROLE_GET_USERS"})
    @GetMapping(value={"/export"})
    public Resource exportUsers(Optional<String> criteria) {
        LOGGER.debug("Export all users to xlsx file");
        return this.userExternalService.exportUsers(criteria);
    }

    @Secured(value={"ROLE_GET_USERS"})
    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<UserDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria(criteria);
        if (direction.isPresent()) {
            SanityChecker.sanitizeCriteria((Object)direction.get());
        }
        if (orderBy.isPresent()) {
            SanityChecker.checkSecureParameter((String[])new String[]{orderBy.get()});
        }
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, criteria, orderBy, direction});
        return this.userExternalService.getAllPaginated(page, size, criteria, orderBy, direction);
    }

    @GetMapping(value={"/{id}"})
    @Secured(value={"ROLE_GET_USERS"})
    public UserDto getOne(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Get {}", (Object)id);
        return this.userExternalService.getOne(id);
    }

    @Secured(value={"ROLE_GET_USERS", "ROLE_CHECK_USERS"})
    @RequestMapping(path={"/check"}, method={RequestMethod.HEAD})
    public ResponseEntity<Void> checkExist(@RequestParam String criteria) {
        SanityChecker.sanitizeCriteria(Optional.of(criteria));
        LOGGER.debug("Check exists by criteria", (Object)criteria);
        boolean exist = this.userExternalService.checkExists(criteria);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @PostMapping
    @Secured(value={"ROLE_CREATE_USERS"})
    public UserDto create(@Valid @RequestBody UserDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Create {}", (Object)dto);
        return this.userExternalService.create(dto);
    }

    @PutMapping(value={"/{id}"})
    @Secured(value={"ROLE_UPDATE_USERS"})
    public UserDto update(@PathVariable(value="id") String id, @Valid @RequestBody UserDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)dto);
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Update {} with {}", (Object)id, (Object)dto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)dto.getId()), (String)"Unable to update user : the DTO id must match the path id");
        return this.userExternalService.update(dto);
    }

    @PatchMapping(value={"/{id}"})
    @Secured(value={"ROLE_UPDATE_USERS"})
    public UserDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria(partialDto);
        LOGGER.debug("Patch User {} with {}", (Object)id, partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"Unable to patch user : the DTO id must match the path id");
        return this.userExternalService.patch(partialDto);
    }

    @PatchMapping(value={"/me"})
    @Secured(value={"ROLE_ADMIN_UPDATE_ME_USERS"})
    public UserDto patchMe(@RequestBody Map<String, Object> partialDto) throws PreconditionFailedException {
        SanityChecker.sanitizeCriteria(partialDto);
        LOGGER.debug("Patch me with {}", partialDto);
        return this.userExternalService.patchMe(partialDto);
    }

    @GetMapping(value={"/{id}/history"})
    public LogbookOperationsResponseDto findHistoryById(@PathVariable(value="id") String id) {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for user with id :{}", (Object)id);
        return this.userExternalService.findHistoryById(id);
    }

    @GetMapping(value={"/levels"})
    @Secured(value={"ROLE_GET_USERS"})
    public List<String> getLevels(Optional<String> criteria) {
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("Get levels with criteria={}", criteria);
        return this.userExternalService.getLevels(criteria);
    }

    @PostMapping(value={"/analytics"})
    public UserDto patchAnalytics(@RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria(partialDto);
        LOGGER.debug("Patch analytics with {}", partialDto);
        return this.userExternalService.patchAnalytics(partialDto);
    }

    @Generated
    public UserExternalService getUserExternalService() {
        return this.userExternalService;
    }
}

