/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.GroupDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.domain.UserDto;
import fr.gouv.vitamui.commons.api.exception.NotImplementedException;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.CrudController;
import fr.gouv.vitamui.iam.common.dto.SubrogationDto;
import fr.gouv.vitamui.iam.external.server.service.SubrogationExternalService;
import io.swagger.annotations.Api;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/subrogations"})
@Api(tags={"subrogations"}, value="Subrogation Management", description="Subrogation Management")
public class SubrogationExternalController
implements CrudController<SubrogationDto> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(SubrogationExternalController.class);
    private final SubrogationExternalService subrogationExternalService;

    @Autowired
    public SubrogationExternalController(SubrogationExternalService subrogationCrudService) {
        this.subrogationExternalService = subrogationCrudService;
    }

    @GetMapping
    @Secured(value={"ROLE_GET_SUBROGATIONS"})
    public List<SubrogationDto> getAll(@RequestParam Optional<String> criteria) {
        return this.subrogationExternalService.getAll(criteria);
    }

    @RequestMapping(path={"/{id}"}, method={RequestMethod.HEAD})
    public ResponseEntity<Void> checkExist(@PathVariable(value="id") String id) {
        throw new NotImplementedException("checkExist not supported");
    }

    @GetMapping(value={"/{id}"})
    @Secured(value={"ROLE_GET_SUBROGATIONS"})
    public SubrogationDto getOne(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Get {}", (Object)id);
        return this.subrogationExternalService.getOne(id);
    }

    @PostMapping
    @Secured(value={"ROLE_CREATE_SUBROGATIONS"})
    public SubrogationDto create(@Valid @RequestBody SubrogationDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Create {}", (Object)dto);
        return this.subrogationExternalService.create(dto);
    }

    @Secured(value={"ROLE_GET_USERS_SUBROGATIONS"})
    @GetMapping(path={"/users/generic"}, params={"page", "size"})
    public PaginatedValuesDto<UserDto> getGenericUsers(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria(criteria);
        if (direction.isPresent()) {
            SanityChecker.sanitizeCriteria((Object)direction.get());
        }
        if (orderBy.isPresent()) {
            SanityChecker.checkSecureParameter((String[])new String[]{orderBy.get()});
        }
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, criteria, orderBy, direction});
        return this.subrogationExternalService.getGenericUsers(page, size, criteria, orderBy, direction);
    }

    @GetMapping(path={"/groups/{id}"})
    @Secured(value={"ROLE_GET_GROUPS_SUBROGATIONS"})
    public GroupDto getGroupById(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Get group {}", (Object)id);
        return this.subrogationExternalService.getGroupById(id);
    }

    @PutMapping(value={"/{id}"})
    public SubrogationDto update(@PathVariable(value="id") String id, @Valid @RequestBody SubrogationDto dto) {
        throw new NotImplementedException("Update not supported");
    }

    @PatchMapping(value={"/surrogate/accept/{id}"})
    public SubrogationDto accept(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Accepte subrogation id : {}", (Object)id);
        return this.subrogationExternalService.accept(id);
    }

    @DeleteMapping(value={"/surrogate/decline/{id}"})
    public void decline(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Decline subrogation id : {}", (Object)id);
        this.subrogationExternalService.decline(id);
    }

    @GetMapping(value={"/me/surrogate"})
    public SubrogationDto getMySubrogationAsSurrogate() {
        return this.subrogationExternalService.getMySubrogationAsSurrogate();
    }

    @GetMapping(value={"/me/superuser"})
    public SubrogationDto getMySubrogationAsSuperuser() {
        return this.subrogationExternalService.getMySubrogationAsSuperuser();
    }

    @DeleteMapping(value={"/{id}"})
    @Secured(value={"ROLE_DELETE_SUBROGATIONS"})
    public void delete(@PathVariable String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        this.subrogationExternalService.delete(id);
    }

    @Generated
    public SubrogationExternalService getSubrogationExternalService() {
        return this.subrogationExternalService;
    }
}

