/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.domain.ProfileDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.api.utils.EnumUtils;
import fr.gouv.vitamui.commons.rest.CrudController;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.iam.common.dto.common.EmbeddedOptions;
import fr.gouv.vitamui.iam.external.server.service.ProfileExternalService;
import io.swagger.annotations.Api;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/profiles"})
@Api(tags={"profiles"}, value="Profiles Management", description="Profiles Management")
public class ProfileExternalController
implements CrudController<ProfileDto> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ProfileExternalController.class);
    private final ProfileExternalService profileExternalService;

    @Autowired
    public ProfileExternalController(ProfileExternalService profileExternalService) {
        this.profileExternalService = profileExternalService;
    }

    @GetMapping
    @Secured(value={"ROLE_GET_PROFILES"})
    public Collection<ProfileDto> getAll(Optional<String> criteria, @RequestParam Optional<String> embedded) {
        SanityChecker.sanitizeCriteria(criteria);
        EnumUtils.checkValidEnum(EmbeddedOptions.class, embedded);
        LOGGER.debug("Get all with criteria={}, embedded={}", criteria, embedded);
        return this.profileExternalService.getAll(criteria, embedded);
    }

    @Secured(value={"ROLE_GET_PROFILES"})
    @RequestMapping(path={"/check"}, method={RequestMethod.HEAD})
    public ResponseEntity<Void> checkExist(@RequestParam String criteria) {
        SanityChecker.sanitizeCriteria(Optional.of(criteria));
        LOGGER.debug("checkExist criteria={}", (Object)criteria);
        boolean exist = this.profileExternalService.checkExists(criteria);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @GetMapping(value={"/{id}"})
    @Secured(value={"ROLE_GET_PROFILES"})
    public ProfileDto getOne(@PathVariable(value="id") String id, @RequestParam Optional<String> embedded) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        EnumUtils.checkValidEnum(EmbeddedOptions.class, embedded);
        LOGGER.debug("Get {}, embedded={}", (Object)id, embedded);
        return this.profileExternalService.getOne(id, embedded);
    }

    @PostMapping
    @Secured(value={"ROLE_CREATE_PROFILES"})
    public ProfileDto create(@Valid @RequestBody ProfileDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Create {}", (Object)dto);
        return this.profileExternalService.create(dto);
    }

    public ProfileDto update(@PathVariable(value="id") String id, @Valid @RequestBody ProfileDto dto) {
        throw new UnsupportedOperationException("update not implemented");
    }

    @Secured(value={"ROLE_GET_PROFILES"})
    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<ProfileDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction, @RequestParam(required=false) Optional<String> embedded) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria(criteria);
        if (direction.isPresent()) {
            SanityChecker.sanitizeCriteria((Object)direction.get());
        }
        if (orderBy.isPresent()) {
            SanityChecker.checkSecureParameter((String[])new String[]{orderBy.get()});
        }
        LOGGER.debug("getAllPaginated page={}, size={}, criteria={}, orderBy={}, ascendant={}, embedded = {}", new Object[]{page, size, criteria, orderBy, direction, embedded});
        EnumUtils.checkValidEnum(EmbeddedOptions.class, embedded);
        PaginatedValuesDto result = this.profileExternalService.getAllPaginated(page, size, criteria, orderBy, direction, embedded);
        return result;
    }

    @PatchMapping(value={"/{id}"})
    @Secured(value={"ROLE_UPDATE_PROFILES"})
    public ProfileDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria(partialDto);
        LOGGER.debug("Patch {} with {}", (Object)id, partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for update.");
        return this.profileExternalService.patch(partialDto);
    }

    @GetMapping(value={"/{id}/history"})
    public LogbookOperationsResponseDto findHistoryById(@PathVariable(value="id") String id) {
        LOGGER.debug("get logbook for user with id :{}", (Object)id);
        return this.profileExternalService.findHistoryById(id);
    }

    @GetMapping(value={"/levels"})
    @Secured(value={"ROLE_GET_PROFILES"})
    public List<String> getLevels(Optional<String> criteria) {
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("Get levels with criteria={}", criteria);
        return this.profileExternalService.getLevels(criteria);
    }

    @Generated
    public ProfileExternalService getProfileExternalService() {
        return this.profileExternalService;
    }
}

