/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.ExternalParamProfileDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.api.utils.EnumUtils;
import fr.gouv.vitamui.commons.rest.CrudController;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.iam.common.dto.common.EmbeddedOptions;
import fr.gouv.vitamui.iam.external.server.service.ExternalParamProfileExternalService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/externalparamprofile"})
@Api(tags={"externalparamprofile"}, value="Access Contract External Parameters Profile")
public class ExternalParamProfileExternalController
implements CrudController<ExternalParamProfileDto> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ExternalParamProfileExternalController.class);
    private final ExternalParamProfileExternalService service;

    @Autowired
    public ExternalParamProfileExternalController(ExternalParamProfileExternalService externalParamProfileExternalService) {
        this.service = externalParamProfileExternalService;
    }

    @Secured(value={"ROLE_SEARCH_EXTERNAL_PARAM_PROFILE"})
    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<ExternalParamProfileDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction, @RequestParam(required=false) Optional<String> embedded) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria(criteria);
        if (direction.isPresent()) {
            SanityChecker.sanitizeCriteria((Object)direction.get());
        }
        if (orderBy.isPresent()) {
            SanityChecker.checkSecureParameter((String[])new String[]{orderBy.get()});
        }
        EnumUtils.checkValidEnum(EmbeddedOptions.class, embedded);
        LOGGER.debug("getAllPaginated page={}, size={}, criteria={}, orderBy={}, ascendant={}, embedded = {}", new Object[]{page, size, criteria, orderBy, direction, embedded});
        EnumUtils.checkValidEnum(EmbeddedOptions.class, embedded);
        return this.service.getAllPaginated(page, size, criteria, orderBy, direction, embedded);
    }

    @RequestMapping(path={"/check"}, method={RequestMethod.HEAD})
    @Secured(value={"ROLE_CREATE_EXTERNAL_PARAM_PROFILE"})
    public ResponseEntity<Void> checkExist(String criteria) {
        SanityChecker.sanitizeCriteria(Optional.of(criteria));
        LOGGER.debug("checkExist criteria={}", (Object)criteria);
        boolean exist = this.service.checkExists(criteria);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @ApiOperation(value="Create external parameter profile")
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @Secured(value={"ROLE_EDIT_EXTERNAL_PARAM_PROFILE"})
    public ExternalParamProfileDto create(@RequestBody ExternalParamProfileDto entityDto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)entityDto);
        LOGGER.debug("create class={}", (Object)entityDto.getClass().getName());
        return this.service.create(entityDto);
    }

    @ApiOperation(value="Update external parameter profile")
    @PutMapping(value={"/{id}"})
    @Secured(value={"ROLE_EDIT_EXTERNAL_PARAM_PROFILE"})
    public ExternalParamProfileDto update(String id, ExternalParamProfileDto dto) {
        throw new UnsupportedOperationException("update not implemented");
    }

    @GetMapping(value={"/{id}"})
    @Secured(value={"ROLE_SEARCH_EXTERNAL_PARAM_PROFILE"})
    public ExternalParamProfileDto getOne(@PathVariable String id) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Get One with id : {}", (Object)id);
        return this.service.getOne(id);
    }

    @ApiOperation(value="get history by external parameter profile profile's id")
    @GetMapping(value={"/{id}/history"})
    @Secured(value={"ROLE_SEARCH_EXTERNAL_PARAM_PROFILE"})
    public LogbookOperationsResponseDto findHistoryById(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for external parameter profile with id :{}", (Object)id);
        return this.service.findHistoryById(id);
    }

    @PatchMapping(value={"/{id}"})
    @Secured(value={"ROLE_EDIT_EXTERNAL_PARAM_PROFILE"})
    public ExternalParamProfileDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria(partialDto);
        LOGGER.debug("Patch {} with {}", (Object)id, partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for update.");
        return this.service.patch(partialDto);
    }

    @PatchMapping(value={"/me"})
    @Secured(value={"ROLE_EDIT_EXTERNAL_PARAM_PROFILE"})
    public ExternalParamProfileDto patchMe(@RequestBody Map<String, Object> partialDto) throws PreconditionFailedException {
        SanityChecker.sanitizeCriteria(partialDto);
        return this.service.patch(partialDto);
    }
}

