/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.enums.AttachmentType;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.CrudController;
import fr.gouv.vitamui.commons.rest.enums.ContentDispositionType;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.iam.common.dto.CustomerCreationFormData;
import fr.gouv.vitamui.iam.common.dto.CustomerDto;
import fr.gouv.vitamui.iam.common.dto.CustomerPatchFormData;
import fr.gouv.vitamui.iam.common.utils.CustomerDtoEditor;
import fr.gouv.vitamui.iam.common.utils.MapEditor;
import fr.gouv.vitamui.iam.external.server.service.CustomerExternalService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.beans.PropertyEditor;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.Assert;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/customers"})
@Api(tags={"customers"}, value="Customers Management", description="Customers Management")
public class CustomerExternalController
implements CrudController<CustomerDto> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(CustomerExternalController.class);
    private final CustomerExternalService customerExternalService;

    @Autowired
    public CustomerExternalController(CustomerExternalService customerExternalService) {
        this.customerExternalService = customerExternalService;
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(CustomerDto.class, (PropertyEditor)new CustomerDtoEditor());
        binder.registerCustomEditor(Map.class, (PropertyEditor)new MapEditor());
    }

    @GetMapping
    @Secured(value={"ROLE_GET_CUSTOMERS"})
    public Collection<CustomerDto> getAll(Optional<String> criteria) {
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("get all customer criteria={}", criteria);
        return this.customerExternalService.getAll(criteria);
    }

    @Secured(value={"ROLE_GET_CUSTOMERS"})
    @RequestMapping(path={"/check"}, method={RequestMethod.HEAD})
    public ResponseEntity<Void> checkExist(@RequestParam String criteria) {
        SanityChecker.sanitizeCriteria(Optional.of(criteria));
        LOGGER.debug("check exist by criteria={}", (Object)criteria);
        boolean exist = this.customerExternalService.checkExists(criteria);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @Secured(value={"ROLE_GET_CUSTOMERS"})
    @GetMapping(value={"/{id}"})
    public CustomerDto getOne(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        LOGGER.debug("Get {}", (Object)id);
        return this.customerExternalService.getOne(id);
    }

    @GetMapping(path={"/me"})
    public CustomerDto getMyCustomer() {
        return this.customerExternalService.getMyCustomer();
    }

    @Secured(value={"ROLE_GET_CUSTOMERS"})
    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<CustomerDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria(criteria);
        if (direction.isPresent()) {
            SanityChecker.sanitizeCriteria((Object)direction.get());
        }
        if (orderBy.isPresent()) {
            SanityChecker.checkSecureParameter((String[])new String[]{orderBy.get()});
        }
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, orderBy, direction});
        return this.customerExternalService.getAllPaginated(page, size, criteria, orderBy, direction);
    }

    @Secured(value={"ROLE_CREATE_CUSTOMERS"})
    @PostMapping(consumes={"multipart/form-data"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public CustomerDto create(@ModelAttribute CustomerCreationFormData customerData) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)customerData);
        LOGGER.debug("Create {}", (Object)customerData);
        return this.customerExternalService.create(customerData);
    }

    @Secured(value={"ROLE_UPDATE_CUSTOMERS"})
    @PutMapping(value={"/{id}"})
    public CustomerDto update(@PathVariable(value="id") String id, @Valid @RequestBody CustomerDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Update {} with {}", (Object)id, (Object)dto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)dto.getId()), (String)"The DTO identifier must match the path identifier for update.");
        return this.customerExternalService.update(dto);
    }

    @ApiOperation(value="Patch customer entity")
    @PatchMapping(value={"/{id}"})
    @Secured(value={"ROLE_UPDATE_CUSTOMERS"})
    public CustomerDto patch(@PathVariable(value="id") String id, @ModelAttribute CustomerPatchFormData customerData) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria((Object)customerData.getPartialCustomerDto());
        LOGGER.debug("Patch customer with {}", customerData.getPartialCustomerDto().get("id"));
        return this.customerExternalService.patch(customerData);
    }

    @GetMapping(value={"/{id}/history"})
    public LogbookOperationsResponseDto findHistoryById(@PathVariable(value="id") String id) {
        LOGGER.debug("get logbook for customer with id :{}", (Object)id);
        return this.customerExternalService.findHistoryById(id);
    }

    public CustomerDto create(CustomerDto dto) {
        throw new NotImplementedException("Method is not implemented");
    }

    public CustomerDto patch(String id, Map<String, Object> partialCustomerDto) {
        throw new NotImplementedException("Method is not implemented");
    }

    @ApiOperation(value="Get entity logo")
    @GetMapping(value={"/{id}/logo"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<Resource> getLogo(@PathVariable String id, @RequestParam(value="type") AttachmentType type) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logo for customer with id :{}, type : {}", (Object)id, (Object)type);
        ResponseEntity response = this.customerExternalService.getLogo(id, type);
        if (HttpStatus.NO_CONTENT.equals((Object)response.getStatusCode())) {
            return response;
        }
        return RestUtils.buildFileResponse((ResponseEntity)response, Optional.of(ContentDispositionType.INLINE), Optional.empty());
    }

    @ApiOperation(value="Get Gdpr Setting Status")
    @GetMapping(value={"/gdpr-status"})
    @ResponseStatus(value=HttpStatus.OK)
    public boolean getGdprSettingStatus() {
        LOGGER.debug("Get Gdpr Setting Status");
        return this.customerExternalService.getGdprSettingStatus();
    }

    @Generated
    public CustomerExternalService getCustomerExternalService() {
        return this.customerExternalService;
    }
}

