/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.UserDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.iam.common.dto.CustomerDto;
import fr.gouv.vitamui.iam.common.dto.SubrogationDto;
import fr.gouv.vitamui.iam.common.dto.cas.LoginRequestDto;
import fr.gouv.vitamui.iam.external.server.service.CasExternalService;
import io.swagger.annotations.Api;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/cas"})
@Api(tags={"cas"}, value="User authentication management for CAS", description="User authentication management for CAS")
public class CasExternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(CasExternalController.class);
    private final CasExternalService casService;

    @Autowired
    public CasExternalController(CasExternalService casService) {
        this.casService = casService;
    }

    @PostMapping(value={"/login"})
    @Secured(value={"ROLE_CAS_LOGIN"})
    public ResponseEntity<UserDto> login(@Valid @RequestBody LoginRequestDto dto) {
        UserDto user = this.casService.login(dto);
        return new ResponseEntity((Object)user, HttpStatus.OK);
    }

    @PostMapping(value={"/password/change"})
    @Secured(value={"ROLE_CAS_CHANGE_PASSWORD"})
    @ResponseBody
    public String changePassword(@RequestHeader String username, @RequestHeader String password, @RequestHeader String customerId) throws PreconditionFailedException {
        LOGGER.debug("changePassword for username: {} / password_exists? {} customerId ", new Object[]{username, StringUtils.isNotBlank((CharSequence)password), StringUtils.isNotBlank((CharSequence)customerId)});
        ParameterChecker.checkParameter((String)"The user, customer id and password are mandatory : ", (String[])new String[]{username, customerId, password});
        SanityChecker.checkSecureParameter((String[])new String[]{username});
        this.casService.changePassword(username, password, customerId);
        return "true";
    }

    @GetMapping(value={"/users"}, params={"email"})
    @Secured(value={"ROLE_CAS_USERS"})
    public List<? extends UserDto> getUsersByEmail(@RequestParam String email, @RequestParam Optional<String> embedded) {
        LOGGER.debug("getUserByEmail: {} embedded: {}", (Object)email, embedded);
        ParameterChecker.checkParameter((String)"The email is mandatory : ", (String[])new String[]{email});
        return this.casService.getUsersByEmail(email, embedded);
    }

    @GetMapping(value={"/users/provisioning"}, params={"loginEmail", "loginCustomerId", "idp"})
    @Secured(value={"ROLE_CAS_USERS"})
    public UserDto getUser(@RequestParam String loginEmail, @RequestParam String loginCustomerId, @RequestParam String idp, @RequestParam Optional<String> userIdentifier, @RequestParam Optional<String> embedded) {
        LOGGER.debug("getUser - email : {}, customerId : {}, idp : {}, user identifier : {}, embedded: {}", new Object[]{loginEmail, loginCustomerId, idp, userIdentifier, embedded});
        return this.casService.getUser(loginEmail, loginCustomerId, idp, userIdentifier, embedded);
    }

    @GetMapping(value={"/users"}, params={"id"})
    @Secured(value={"ROLE_CAS_USERS"})
    public UserDto getUserById(@RequestParam String id) throws PreconditionFailedException {
        LOGGER.debug("getUserById: {}", (Object)id);
        ParameterChecker.checkParameter((String)"The identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        return this.casService.getUserById(id);
    }

    @GetMapping(value={"/subrogations"}, params={"superUserEmail", "superUserCustomerId"})
    @Secured(value={"ROLE_CAS_SUBROGATIONS"})
    public List<SubrogationDto> getSubrogationsBySuperUserEmailAndCustomerId(@RequestParam String superUserEmail, @RequestParam String superUserCustomerId) {
        LOGGER.debug("getMySubrogationAsSuperuser: {} / {}", (Object)superUserEmail, (Object)superUserCustomerId);
        ParameterChecker.checkParameter((String)"The superUserEmail is mandatory : ", (String[])new String[]{superUserEmail});
        ParameterChecker.checkParameter((String)"The superUserCustomerId is mandatory : ", (String[])new String[]{superUserCustomerId});
        return this.casService.getSubrogationsBySuperUserAndCustomerId(superUserEmail, superUserCustomerId);
    }

    @GetMapping(value={"/subrogations"}, params={"superUserId"})
    @Secured(value={"ROLE_CAS_SUBROGATIONS"})
    public List<SubrogationDto> getSubrogationsBySuperUserId(@RequestParam String superUserId) throws InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("getSubrogationsBySuperUserId: {}", (Object)superUserId);
        ParameterChecker.checkParameter((String)"The superUserId is mandatory : ", (String[])new String[]{superUserId});
        SanityChecker.checkSecureParameter((String[])new String[]{superUserId});
        return this.casService.getSubrogationsBySuperUserId(superUserId);
    }

    @GetMapping(value={"/logout"})
    @Secured(value={"ROLE_CAS_LOGOUT"})
    @ResponseStatus(value=HttpStatus.OK)
    public void logout(@RequestParam String authToken, @RequestParam String superUser, @RequestParam String superUserCustomerId) {
        LOGGER.debug("logout: authToken={}, superUser={}, superUserCustomerId={}", new Object[]{authToken, superUser, superUserCustomerId});
        ParameterChecker.checkParameter((String)"The authToken is mandatory : ", (String[])new String[]{authToken});
        this.casService.logout(authToken, superUser, superUserCustomerId);
    }

    @GetMapping(value={"/customers"})
    @Secured(value={"ROLE_CAS_CUSTOMERS"})
    public Collection<CustomerDto> getCustomersByIds(@RequestParam List<String> customerIds) {
        LOGGER.debug("get all customers by ids={}", customerIds);
        ParameterChecker.checkParameter((String)"CustomerIds are mandatory : ", (Object[])new Object[]{customerIds});
        SanityChecker.checkSecureParameter((String[])customerIds.toArray(new String[0]));
        return this.casService.getCustomersByIds(customerIds);
    }
}

