/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.server.rest;

import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.domain.ApplicationDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.api.utils.EnumUtils;
import fr.gouv.vitamui.commons.rest.CrudController;
import fr.gouv.vitamui.iam.common.dto.common.EmbeddedOptions;
import fr.gouv.vitamui.iam.external.server.service.ApplicationExternalService;
import fr.gouv.vitamui.iam.external.server.service.ApplicationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/applications"})
@Api(tags={"applications"}, value="Applications Management")
public class ApplicationExternalController
implements CrudController<ApplicationDto> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ApplicationExternalController.class);
    private final ApplicationExternalService applicationExternalService;
    private final ApplicationService applicationService;

    @Autowired
    public ApplicationExternalController(ApplicationExternalService applicationExternalService, ApplicationService applicationService) {
        this.applicationExternalService = applicationExternalService;
        this.applicationService = applicationService;
    }

    @GetMapping
    public List<ApplicationDto> getAll(Optional<String> criteria, @RequestParam Optional<String> embedded) {
        SanityChecker.sanitizeCriteria(criteria);
        EnumUtils.checkValidEnum(EmbeddedOptions.class, embedded);
        LOGGER.debug("Get all with criteria={}, embedded={}", criteria, embedded);
        EnumUtils.checkValidEnum(EmbeddedOptions.class, embedded);
        return this.applicationExternalService.getAll(criteria, embedded);
    }

    @GetMapping(value={"/filtered"})
    @ApiOperation(value="Return config about applications and categories")
    public Map<String, Object> getApplicationsFromUi(@RequestParam(defaultValue="true") boolean filterApp) {
        LOGGER.debug("getApplications");
        return this.applicationService.getApplications(filterApp);
    }

    @GetMapping(path={"/{identifier:.+}/externalid"})
    @ApiOperation(value="Check if an application can have an external identifier")
    public ResponseEntity<Boolean> isApplicationExternalIdentifierEnabled(@PathVariable(value="identifier") String identifier) {
        SanityChecker.checkSecureParameter((String[])new String[]{identifier});
        LOGGER.debug("isApplicationExternalIdentifierEnabled");
        return this.applicationService.isApplicationExternalIdentifierEnabled(identifier);
    }

    public ResponseEntity<Void> checkExist(String id) {
        throw new UnsupportedOperationException("check exist not implemented");
    }

    public ApplicationDto create(@Valid @RequestBody ApplicationDto dto) {
        throw new UnsupportedOperationException("create not implemented");
    }

    public ApplicationDto update(@PathVariable(value="id") String id, @Valid @RequestBody ApplicationDto dto) {
        throw new UnsupportedOperationException("update not implemented");
    }

    @PatchMapping(value={"/{id}"})
    public ApplicationDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) {
        throw new UnsupportedOperationException("patch not implemented");
    }

    @Generated
    public ApplicationExternalService getApplicationExternalService() {
        return this.applicationExternalService;
    }

    @Generated
    public ApplicationService getApplicationService() {
        return this.applicationService;
    }
}

