/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archives.search.external.client;

import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationDto;
import java.io.InputStream;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class ArchiveSearchStreamingExternalRestClient
extends BasePaginatingAndSortingRestClient<LogbookOperationDto, ExternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ArchiveSearchStreamingExternalRestClient.class);

    public ArchiveSearchStreamingExternalRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    public String getPathUrl() {
        return "/archives-search";
    }

    protected Class<LogbookOperationDto> getDtoClass() {
        return LogbookOperationDto.class;
    }

    protected ParameterizedTypeReference<List<LogbookOperationDto>> getDtoListClass() {
        return new ParameterizedTypeReference<List<LogbookOperationDto>>(){};
    }

    protected ParameterizedTypeReference<PaginatedValuesDto<LogbookOperationDto>> getDtoPaginatedClass() {
        return new ParameterizedTypeReference<PaginatedValuesDto<LogbookOperationDto>>(){};
    }

    public ResponseEntity<Resource> downloadObjectFromUnit(String id, String usage, Integer version, ExternalHttpContext context) {
        LOGGER.debug("download binary object with id : {}, version : {}, usage : {}", new Object[]{id, version, usage});
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/downloadobjectfromunit/{id}?usage=" + usage + "&version=" + version));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity responseEntity = this.restTemplate.exchange(uriBuilder.build(new Object[]{id}), HttpMethod.GET, request, Resource.class);
        return ResponseEntity.ok().contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)((Resource)responseEntity.getBody()));
    }

    public ResponseEntity<String> transferAcknowledgment(ExternalHttpContext context, String fileName, InputStream inputStream) {
        LOGGER.debug("Calling transfer Acknowledgment using streaming process");
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/transfer-acknowledgment"));
        HttpHeaders headersList = new HttpHeaders();
        headersList.addAll(this.buildHeaders((AbstractHttpContext)context));
        headersList.add((Object)"X-Original-Filename", (Object)fileName);
        HttpHeaders headersParams = new HttpHeaders();
        headersParams.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        headersParams.addAll((MultiValueMap)headersList);
        HttpEntity request = new HttpEntity((Object)new InputStreamResource(inputStream), (MultiValueMap)headersParams);
        return this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.POST, request, String.class, new Object[0]);
    }
}

