/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archives.search.external.client;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.archives.search.common.dto.ArchiveUnitsDto;
import fr.gouv.vitamui.archives.search.common.dto.ExportDipCriteriaDto;
import fr.gouv.vitamui.archives.search.common.dto.ReclassificationCriteriaDto;
import fr.gouv.vitamui.archives.search.common.dto.RuleSearchCriteriaDto;
import fr.gouv.vitamui.archives.search.common.dto.TransferRequestDto;
import fr.gouv.vitamui.archives.search.common.dto.VitamUIArchiveUnitResponseDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaDto;
import fr.gouv.vitamui.commons.api.dtos.VitamUiOntologyDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import fr.gouv.vitamui.commons.vitam.api.dto.PersistentIdentifierResponseDto;
import fr.gouv.vitamui.commons.vitam.api.dto.ResultsDto;
import fr.gouv.vitamui.commons.vitam.api.dto.VitamUISearchResponseDto;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class ArchiveSearchExternalRestClient
extends BasePaginatingAndSortingRestClient<ArchiveUnitsDto, ExternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ArchiveSearchExternalRestClient.class);

    public ArchiveSearchExternalRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    protected Class<ArchiveUnitsDto> getDtoClass() {
        return ArchiveUnitsDto.class;
    }

    protected ParameterizedTypeReference<List<ArchiveUnitsDto>> getDtoListClass() {
        return new ParameterizedTypeReference<List<ArchiveUnitsDto>>(){};
    }

    protected ParameterizedTypeReference<PaginatedValuesDto<ArchiveUnitsDto>> getDtoPaginatedClass() {
        return new ParameterizedTypeReference<PaginatedValuesDto<ArchiveUnitsDto>>(){};
    }

    public String getPathUrl() {
        return "/archives-search";
    }

    public VitamUIArchiveUnitResponseDto searchArchiveUnitsByCriteria(ExternalHttpContext context, SearchCriteriaDto query) {
        LOGGER.debug("Calling search archives units by criteria");
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity((Object)query, headers);
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/search", HttpMethod.POST, request, VitamUIArchiveUnitResponseDto.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (VitamUIArchiveUnitResponseDto)response.getBody();
    }

    public VitamUISearchResponseDto getFilingHoldingScheme(ExternalHttpContext context) {
        LOGGER.debug("Calling get filing holding scheme");
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity(headers);
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/filling-holding-schema", HttpMethod.GET, request, VitamUISearchResponseDto.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (VitamUISearchResponseDto)response.getBody();
    }

    public ResponseEntity<ResultsDto> findUnitById(String id, ExternalHttpContext context) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/archiveunit/{id}"));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        return this.restTemplate.exchange(uriBuilder.build(new Object[]{id}), HttpMethod.GET, request, ResultsDto.class);
    }

    public ResponseEntity<ResultsDto> findObjectById(String id, ExternalHttpContext context) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/object/{id}"));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        return this.restTemplate.exchange(uriBuilder.build(new Object[]{id}), HttpMethod.GET, request, ResultsDto.class);
    }

    public ResponseEntity<Resource> exportCsvArchiveUnitsByCriteria(SearchCriteriaDto query, ExternalHttpContext context) {
        LOGGER.debug("Calling export to csv search archives units by criteria");
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity((Object)query, headers);
        return this.restTemplate.exchange(this.getUrl() + "/export-csv-search", HttpMethod.POST, request, Resource.class, new Object[0]);
    }

    public ResponseEntity<String> exportDIPCriteria(ExportDipCriteriaDto exportDipCriteriaDto, ExternalHttpContext context) {
        LOGGER.debug("Calling export DIP by criteria");
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity((Object)exportDipCriteriaDto, headers);
        return this.restTemplate.exchange(this.getUrl() + "/export-dip", HttpMethod.POST, request, String.class, new Object[0]);
    }

    public ResponseEntity<String> transferRequest(TransferRequestDto transferRequestDto, ExternalHttpContext context) {
        LOGGER.debug("Calling transfer request");
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity((Object)transferRequestDto, headers);
        return this.restTemplate.exchange(this.getUrl() + "/transfer-request", HttpMethod.POST, request, String.class, new Object[0]);
    }

    public ResponseEntity<JsonNode> startEliminationAnalysis(ExternalHttpContext context, SearchCriteriaDto query) {
        LOGGER.debug("Calling elimination analysis by criteria");
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity((Object)query, headers);
        return this.restTemplate.exchange(this.getUrl() + "/elimination/analysis", HttpMethod.POST, request, JsonNode.class, new Object[0]);
    }

    public ResponseEntity<JsonNode> startEliminationAction(ExternalHttpContext context, SearchCriteriaDto query) {
        LOGGER.debug("Calling elimination action by using criteria {}", (Object)query);
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity((Object)query, headers);
        return this.restTemplate.exchange(this.getUrl() + "/elimination/action", HttpMethod.POST, request, JsonNode.class, new Object[0]);
    }

    public ResponseEntity<String> updateArchiveUnitsRules(RuleSearchCriteriaDto ruleSearchCriteriaDto, ExternalHttpContext context) {
        LOGGER.debug("Calling updateArchiveUnitsRules by criteria");
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity((Object)ruleSearchCriteriaDto, headers);
        return this.restTemplate.exchange(this.getUrl() + "/units/rules", HttpMethod.POST, request, String.class, new Object[0]);
    }

    public ResponseEntity<String> computedInheritedRules(SearchCriteriaDto searchCriteriaDto, ExternalHttpContext context) {
        LOGGER.debug("Calling computed inherited rules by criteria");
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity((Object)searchCriteriaDto, headers);
        return this.restTemplate.exchange(this.getUrl() + "/computed-inherited-rules", HttpMethod.POST, request, String.class, new Object[0]);
    }

    public ResponseEntity<ResultsDto> selectUnitWithInheritedRules(ExternalHttpContext context, SearchCriteriaDto query) {
        LOGGER.debug("Calling select Unit With Inherited Rules by criteria");
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity((Object)query, headers);
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/unit-with-inherited-rules", HttpMethod.POST, request, ResultsDto.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return response;
    }

    public ResponseEntity<String> reclassification(ReclassificationCriteriaDto reclassificationCriteriaDto, ExternalHttpContext context) {
        LOGGER.debug("Calling reclassification with query {} ", (Object)reclassificationCriteriaDto);
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity((Object)reclassificationCriteriaDto, headers);
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/reclassification", HttpMethod.POST, request, String.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return response;
    }

    public List<VitamUiOntologyDto> getExternalOntologyFieldsList(ExternalHttpContext context) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/external-ontologies"));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        return (List)this.restTemplate.exchange(uriBuilder.build().toUri(), HttpMethod.GET, request, ArrayList.class).getBody();
    }

    public PersistentIdentifierResponseDto findUnitsByPersistentIdentifier(String identifier, ExternalHttpContext context) {
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/units-by-persistent-identifier")).queryParam("id", new Object[]{identifier});
        return (PersistentIdentifierResponseDto)this.restTemplate.exchange(uriBuilder.build().toUri(), HttpMethod.GET, request, PersistentIdentifierResponseDto.class).getBody();
    }

    public PersistentIdentifierResponseDto findObjectsByPersistentIdentifier(String identifier, ExternalHttpContext context) {
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/objects-by-persistent-identifier")).queryParam("id", new Object[]{identifier});
        return (PersistentIdentifierResponseDto)this.restTemplate.exchange(uriBuilder.build().toUri(), HttpMethod.GET, request, PersistentIdentifierResponseDto.class).getBody();
    }
}

