/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.pastis.client;

import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import fr.gouv.vitamui.pastis.common.dto.ElementProperties;
import fr.gouv.vitamui.pastis.common.dto.profiles.Notice;
import fr.gouv.vitamui.pastis.common.dto.profiles.ProfileNotice;
import fr.gouv.vitamui.pastis.common.dto.profiles.ProfileResponse;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class PastisTransformationRestClient
extends BasePaginatingAndSortingRestClient<ProfileResponse, ExternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(PastisTransformationRestClient.class);

    public PastisTransformationRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    protected Class<ProfileResponse> getDtoClass() {
        return ProfileResponse.class;
    }

    protected ParameterizedTypeReference<List<ProfileResponse>> getDtoListClass() {
        return new ParameterizedTypeReference<List<ProfileResponse>>(){};
    }

    protected ParameterizedTypeReference<PaginatedValuesDto<ProfileResponse>> getDtoPaginatedClass() {
        return new ParameterizedTypeReference<PaginatedValuesDto<ProfileResponse>>(){};
    }

    public String getPathUrl() {
        return "/pastis";
    }

    public ResponseEntity<ProfileResponse> loadProfile(Notice notice, ExternalHttpContext context) {
        LOGGER.debug("Transform profile");
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity((Object)notice, headers);
        return this.restTemplate.exchange(this.getUrl() + "/edit", HttpMethod.POST, request, ProfileResponse.class, new Object[0]);
    }

    public ResponseEntity<String> getArchiveProfile(ElementProperties json, ExternalHttpContext context) {
        LOGGER.debug("Download archive profile");
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity((Object)json, headers);
        return this.restTemplate.exchange(this.getUrl() + "/archiveprofile", HttpMethod.POST, request, String.class, new Object[0]);
    }

    public ResponseEntity<String> getArchiveUnitProfile(ProfileNotice json, ExternalHttpContext context) {
        LOGGER.debug("Download Arichivale unit profile");
        MultiValueMap headers = this.buildSearchHeaders(context);
        HttpEntity request = new HttpEntity((Object)json, headers);
        return this.restTemplate.exchange(this.getUrl() + "/getarchiveunitprofile", HttpMethod.POST, request, String.class, new Object[0]);
    }

    public ResponseEntity<ProfileResponse> createProfile(String profileType, ExternalHttpContext context) {
        LOGGER.debug("Transform profile");
        MultiValueMap headers = this.buildSearchHeaders(context);
        HttpEntity request = new HttpEntity(headers);
        return this.restTemplate.exchange(this.getUrl() + "/profile?type=" + profileType, HttpMethod.GET, request, ProfileResponse.class, new Object[0]);
    }
}

