/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.security.service;

import fr.gouv.vitamui.commons.api.exception.NotFoundException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.iam.internal.client.UserInternalRestClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;

public class InternalAuthentificationService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(InternalAuthentificationService.class);
    private final UserInternalRestClient userInternalRestClient;

    @Autowired
    public InternalAuthentificationService(UserInternalRestClient userInternalRestClient) {
        this.userInternalRestClient = userInternalRestClient;
    }

    public AuthUserDto getUserFromHttpContext(InternalHttpContext httpContext) {
        AuthUserDto userProfile;
        String userToken = httpContext.getUserToken();
        if (userToken == null) {
            throw new BadCredentialsException("User token not found: " + userToken);
        }
        try {
            userProfile = this.userInternalRestClient.getMe(httpContext);
        }
        catch (Exception ex) {
            LOGGER.error("Can't find User's Profile for {}. {}", (Object)httpContext, (Object)ex.getMessage());
            throw new BadCredentialsException(ex.getMessage());
        }
        if (userProfile == null) {
            throw new NotFoundException("User profile not found for token: " + userToken);
        }
        return userProfile;
    }
}

