/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.security.service;

import fr.gouv.vitamui.commons.api.domain.ProfileDto;
import fr.gouv.vitamui.commons.api.exception.InvalidFormatException;
import fr.gouv.vitamui.commons.api.exception.NotFoundException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.api.utils.ApiUtils;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import fr.gouv.vitamui.iam.internal.client.UserInternalRestClient;
import fr.gouv.vitamui.security.client.ContextRestClient;
import fr.gouv.vitamui.security.common.dto.ContextDto;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;

public class ExternalAuthentificationService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ExternalAuthentificationService.class);
    private final UserInternalRestClient userInternalRestClient;
    private final ContextRestClient contextRestClient;

    @Autowired
    public ExternalAuthentificationService(ContextRestClient contextRestClient, UserInternalRestClient userInternalRestClient) {
        this.contextRestClient = contextRestClient;
        this.userInternalRestClient = userInternalRestClient;
    }

    public String buildApplicationId(AuthUserDto user, ExternalHttpContext httpContext, ContextDto context) {
        return VitamUIUtils.generateApplicationId((String)httpContext.getApplicationId(), (String)context.getName(), (String)user.getIdentifier(), (String)user.getSuperUserIdentifier(), (String)user.getCustomerIdentifier(), (String)httpContext.getRequestId());
    }

    public AuthUserDto getUserFromHttpContext(ExternalHttpContext httpContext) {
        AuthUserDto userDto = this.getAuthenticatedUser(httpContext);
        Integer tenantIdentifier = httpContext.getTenantIdentifier();
        List userTenants = userDto.getProfileGroup().getProfiles().stream().filter(ProfileDto::isEnabled).map(ProfileDto::getTenantIdentifier).collect(Collectors.toList());
        if (!userTenants.contains(tenantIdentifier)) {
            LOGGER.debug("Tenant id [{}] not in user tenants [{}]", (Object)tenantIdentifier, userTenants);
            throw new BadCredentialsException("This tenant: " + httpContext.getTenantIdentifier() + " is not allowed for this user: " + userDto.getId());
        }
        return userDto;
    }

    public AuthUserDto getAuthenticatedUser(ExternalHttpContext httpContext) {
        String userToken = httpContext.getUserToken();
        if (StringUtils.isBlank((String)userToken)) {
            throw new BadCredentialsException("User token is empty");
        }
        InternalHttpContext internalHttpContext = InternalHttpContext.buildFromExternalHttpContext((ExternalHttpContext)httpContext, null, null);
        AuthUserDto userDto = this.userInternalRestClient.getMe(internalHttpContext);
        if (userDto == null) {
            throw new NotFoundException("User not found for token: " + userToken);
        }
        return userDto;
    }

    public ContextDto getContextFromHttpContext(ExternalHttpContext httpContext, X509Certificate certificate) {
        String certificateBase64;
        try {
            certificateBase64 = Base64.getEncoder().encodeToString(certificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new InvalidFormatException("Invalid certificate: " + e.getMessage());
        }
        InternalHttpContext internalHttpContext = InternalHttpContext.buildFromExternalHttpContext((ExternalHttpContext)httpContext);
        try {
            ContextDto context = this.contextRestClient.findByCertificate(internalHttpContext, certificateBase64);
            LOGGER.debug("authenticateInternal context={}", (Object)context);
            List contextTenants = context.getTenants();
            Integer tenantIdentifier = httpContext.getTenantIdentifier();
            if (!context.isFullAccess() && tenantIdentifier != null && !contextTenants.contains(tenantIdentifier)) {
                LOGGER.warn("[InvalidAuthenticationException] This tenant: {} is not allowed for the application context: {}. credential={}", new Object[]{tenantIdentifier, httpContext.getIdentity(), certificate});
                throw new BadCredentialsException("This tenant: " + tenantIdentifier + " is not allowed for the application context: " + httpContext.getIdentity());
            }
            return context;
        }
        catch (NotFoundException e) {
            LOGGER.error("Certificate not found [IssuerDN={}, certificateBase64={}, credential={}]", new Object[]{certificate.getIssuerDN(), certificateBase64, certificate});
            throw e;
        }
    }

    public List<String> getRoles(ContextDto context, AuthUserDto userProfile, int tenantIdentifier) {
        List contextRoles = context.extractRoleNames();
        LOGGER.debug("context roles: {}", (Object)contextRoles);
        List<String> userRoles = this.getUserRoles(userProfile, tenantIdentifier);
        return contextRoles.stream().filter(userRoles::contains).collect(Collectors.toList());
    }

    protected List<String> getUserRoles(AuthUserDto userProfile, int tenantIdentifier) {
        ArrayList<String> userRoles = new ArrayList<String>();
        userProfile.getProfileGroup().getProfiles().stream().filter(profile -> profile.getTenantIdentifier() == tenantIdentifier).filter(ProfileDto::isEnabled).forEach(profile -> {
            List rolesNames = profile.getRoles().stream().map(role -> ApiUtils.ensureHasRolePrefix((String)role.getName())).collect(Collectors.toList());
            userRoles.addAll(rolesNames);
        });
        LOGGER.debug("user roles: {}", userRoles);
        return userRoles;
    }

    protected InternalHttpContext getInternalHttpContextForUserNotAuthenticated(ExternalHttpContext externalHttpContext) {
        return InternalHttpContext.buildFromExternalHttpContext((ExternalHttpContext)externalHttpContext, null, null);
    }

    @Generated
    public UserInternalRestClient getUserInternalRestClient() {
        return this.userInternalRestClient;
    }

    @Generated
    public ContextRestClient getContextRestClient() {
        return this.contextRestClient;
    }
}

