/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.security.filter;

import fr.gouv.vitamui.commons.api.domain.Role;
import fr.gouv.vitamui.commons.api.exception.ApplicationServerException;
import fr.gouv.vitamui.commons.api.exception.UnAuthorizedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class TenantHeaderFilter
extends OncePerRequestFilter {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(TenantHeaderFilter.class);
    public static final String ROLE_CROSS_TENANTS_SUFFIX = "_OTHER_TENANTS";
    private final InternalSecurityService securityService;
    private final Integer casTenant;

    public TenantHeaderFilter(InternalSecurityService securityService, Integer casTenant) {
        this.securityService = securityService;
        this.casTenant = casTenant;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        block6: {
            String tenantIdHeader = request.getHeader("X-Tenant-Id");
            if (StringUtils.isNotBlank((CharSequence)tenantIdHeader)) {
                try {
                    List<Role> userRoles;
                    boolean hasAnyCrossTenantRole;
                    AuthUserDto user = this.securityService.getUser();
                    Integer requestTenantId = Integer.parseInt(tenantIdHeader);
                    Integer sessionTenantId = user.getProofTenantIdentifier();
                    if (Objects.equals(requestTenantId, sessionTenantId) || (hasAnyCrossTenantRole = (userRoles = InternalSecurityService.getRoles(this.securityService.getUser())).stream().anyMatch(r -> r.getName().endsWith(ROLE_CROSS_TENANTS_SUFFIX))) || this.casTenant.equals(requestTenantId)) break block6;
                    try {
                        this.securityService.getTenant(requestTenantId);
                    }
                    catch (ApplicationServerException e) {
                        LOGGER.error("User not allowed on tenant {}", (Object)tenantIdHeader);
                        response.sendError(403, "Unauthorized access to tenant");
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    LOGGER.warn("Invalid tenant ID format: {}", (Object)tenantIdHeader);
                    response.sendError(400, "Invalid tenant ID format");
                    return;
                }
                catch (UnAuthorizedException e1) {
                    LOGGER.error("User not authenticated ");
                    response.sendError(401, "Unauthorized user");
                    return;
                }
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

