/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.security.filter;

import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.iam.security.filter.X509CertificateExtractor;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class RequestHeaderX509CertificateExtractor
implements X509CertificateExtractor {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(RequestHeaderX509CertificateExtractor.class);
    private String certificateHeaderName = "x-ssl-cert";

    @Override
    public X509Certificate extract(HttpServletRequest request) {
        LOGGER.debug("Get X509 certificate from header " + this.certificateHeaderName);
        String certificate = request.getHeader(this.certificateHeaderName);
        if (StringUtils.isBlank((CharSequence)certificate)) {
            LOGGER.error(String.format("Can not extract X509 certificate from header %s : with error: [Header value is empty!].", this.certificateHeaderName));
            return null;
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(Base64.getDecoder().decode(certificate)));
        }
        catch (CertificateException e) {
            LOGGER.error(String.format("Can not extract X509 certificate from header %s : %s", this.certificateHeaderName, certificate), (Throwable)e);
            return null;
        }
    }

    @Generated
    public void setCertificateHeaderName(String certificateHeaderName) {
        this.certificateHeaderName = certificateHeaderName;
    }
}

