/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.security.config;

import fr.gouv.vitamui.commons.rest.RestExceptionHandler;
import fr.gouv.vitamui.iam.security.config.AbstractApiWebSecurityConfig;
import fr.gouv.vitamui.iam.security.filter.InternalRequestHeadersAuthenticationFilter;
import fr.gouv.vitamui.iam.security.filter.TenantHeaderFilter;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import javax.servlet.Filter;
import lombok.Generated;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

public class InternalApiWebSecurityConfig
extends AbstractApiWebSecurityConfig {
    private static final String CAS_TENANT_IDENTIFIER = "cas.tenant.identifier";
    private final InternalSecurityService internalSecurityService;
    private final Integer casTenantIdentifier;

    public InternalApiWebSecurityConfig(AuthenticationProvider apiAuthenticationProvider, RestExceptionHandler restExceptionHandler, InternalSecurityService internalSecurityService, Environment env) {
        super(apiAuthenticationProvider, restExceptionHandler, env);
        this.internalSecurityService = internalSecurityService;
        this.casTenantIdentifier = (Integer)env.getProperty(CAS_TENANT_IDENTIFIER, Integer.class, (Object)-1);
    }

    @Override
    protected AbstractPreAuthenticatedProcessingFilter getRequestHeadersAuthenticationFilter() throws Exception {
        return new InternalRequestHeadersAuthenticationFilter(this.authenticationManager());
    }

    @Override
    protected void configureFilters(HttpSecurity http) throws Exception {
        http.addFilterAt((Filter)this.getRequestHeadersAuthenticationFilter(), BasicAuthenticationFilter.class);
        http.addFilterAt((Filter)this.getTenantHeaderFilter(), BasicAuthenticationFilter.class);
    }

    protected TenantHeaderFilter getTenantHeaderFilter() {
        return new TenantHeaderFilter(this.internalSecurityService, this.casTenantIdentifier);
    }

    @Generated
    public InternalSecurityService getInternalSecurityService() {
        return this.internalSecurityService;
    }

    @Generated
    public Integer getCasTenantIdentifier() {
        return this.casTenantIdentifier;
    }
}

