/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.security.config;

import fr.gouv.vitamui.commons.rest.RestExceptionHandler;
import fr.gouv.vitamui.iam.security.config.ApiAuthenticationEntryPoint;
import java.util.List;
import javax.servlet.Filter;
import lombok.Generated;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.web.cors.CorsConfiguration;

public abstract class AbstractApiWebSecurityConfig
extends WebSecurityConfigurerAdapter {
    protected AuthenticationProvider apiAuthenticationProvider;
    protected RestExceptionHandler restExceptionHandler;
    protected Environment env;

    public AbstractApiWebSecurityConfig(AuthenticationProvider apiAuthenticationProvider, RestExceptionHandler restExceptionHandler, Environment env) {
        this.apiAuthenticationProvider = apiAuthenticationProvider;
        this.restExceptionHandler = restExceptionHandler;
        this.env = env;
    }

    protected void configure(AuthenticationManagerBuilder auth) {
        auth.authenticationProvider(this.apiAuthenticationProvider);
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(this.getAuthList())).permitAll().anyRequest()).authenticated().and()).cors().configurationSource(request -> this.getCorsConfiguration()).and()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.getUnauthorizedHandler()).and()).csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        this.configureFilters(http);
    }

    protected void configureFilters(HttpSecurity http) throws Exception {
        http.addFilterAt((Filter)this.getRequestHeadersAuthenticationFilter(), BasicAuthenticationFilter.class);
    }

    private CorsConfiguration getCorsConfiguration() {
        CorsConfiguration corsConfiguration = new CorsConfiguration().applyPermitDefaultValues();
        List<String> methodsAllowed = List.of(HttpMethod.GET.name(), HttpMethod.POST.name(), HttpMethod.HEAD.name(), HttpMethod.PATCH.name(), HttpMethod.PUT.name(), HttpMethod.DELETE.name());
        corsConfiguration.setAllowedMethods(methodsAllowed);
        return corsConfiguration;
    }

    public void configure(WebSecurity web) throws Exception {
        web.ignoring().antMatchers(this.getAuthList());
    }

    protected String[] getAuthList() {
        return new String[]{"/error**", "/favicon.ico", "/actuator/**", "*/users/me", "/swagger-resources/**", "/swagger.json", "/**/swagger-resources/**", "/swagger-ui.html", "/v2/api-docs", "/webjars/**"};
    }

    @Bean
    protected ApiAuthenticationEntryPoint getUnauthorizedHandler() {
        return new ApiAuthenticationEntryPoint(this.restExceptionHandler);
    }

    protected abstract AbstractPreAuthenticatedProcessingFilter getRequestHeadersAuthenticationFilter() throws Exception;

    @Generated
    public AuthenticationProvider getApiAuthenticationProvider() {
        return this.apiAuthenticationProvider;
    }

    @Generated
    public RestExceptionHandler getRestExceptionHandler() {
        return this.restExceptionHandler;
    }

    @Generated
    public Environment getEnv() {
        return this.env;
    }

    @Generated
    public void setApiAuthenticationProvider(AuthenticationProvider apiAuthenticationProvider) {
        this.apiAuthenticationProvider = apiAuthenticationProvider;
    }

    @Generated
    public void setRestExceptionHandler(RestExceptionHandler restExceptionHandler) {
        this.restExceptionHandler = restExceptionHandler;
    }

    @Generated
    public void setEnv(Environment env) {
        this.env = env;
    }
}

