/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.administration.ManagementContractService;
import org.springframework.beans.factory.annotation.Autowired;

public class VitamUIManagementContractService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ManagementContractService.class);
    private final AdminExternalClient adminExternalClient;

    @Autowired
    public VitamUIManagementContractService(AdminExternalClient adminExternalClient) {
        this.adminExternalClient = adminExternalClient;
    }

    public RequestResponse<?> patchManagementContract(VitamContext vitamContext, String contractId, JsonNode jsonNode) throws InvalidParseOperationException, PreconditionFailedException, AccessExternalClientException {
        LOGGER.debug("patch: {}, {}", (Object)contractId, (Object)jsonNode);
        LOGGER.debug("Management Contract EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        return this.adminExternalClient.updateManagementContract(vitamContext, contractId, jsonNode);
    }
}

