/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.access.external.common.exception.AccessExternalNotFoundException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.ProfileModel;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.util.VitamRestUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.multipart.MultipartFile;

public class VitamProfileService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(VitamProfileService.class);
    private final AdminExternalClient adminExternalClient;
    private ObjectMapper objectMapper;

    @Autowired
    public VitamProfileService(AdminExternalClient adminExternalClient, ObjectMapper objectMapper) {
        this.adminExternalClient = adminExternalClient;
        this.objectMapper = objectMapper;
    }

    public RequestResponse<ProfileModel> findArchivalProfiles(VitamContext vitamContext, JsonNode select) throws VitamClientException {
        LOGGER.info("Archival Profile EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        RequestResponse response = this.adminExternalClient.findProfiles(vitamContext, select);
        VitamRestUtils.checkResponse((RequestResponse)response, (Integer[])new Integer[0]);
        return response;
    }

    public RequestResponse<ProfileModel> findArchivalProfileById(VitamContext vitamContext, String contractId) throws VitamClientException {
        LOGGER.info("Archival Profile EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        RequestResponse response = this.adminExternalClient.findProfileById(vitamContext, contractId);
        VitamRestUtils.checkResponse((RequestResponse)response, (Integer[])new Integer[0]);
        return response;
    }

    public Response downloadProfile(VitamContext context, String id) throws VitamClientException, AccessExternalClientException, AccessExternalNotFoundException {
        LOGGER.info("Download profile file EvIdAppSession : {} ", (Object)context.getApplicationSessionId());
        return this.adminExternalClient.downloadProfileFile(context, id);
    }

    public RequestResponse updateProfileFile(VitamContext context, String id, MultipartFile file) throws AccessExternalClientException, InvalidParseOperationException, IOException {
        LOGGER.info("Upload Profile xsd or rng EvIdAppSession : {} ", (Object)context.getApplicationSessionId());
        return this.adminExternalClient.createProfileFile(context, id, file.getInputStream());
    }

    public RequestResponse<?> updateProfile(VitamContext vitamContext, String id, JsonNode jsonNode) throws AccessExternalClientException {
        LOGGER.debug("patch: {}, {}", (Object)id, (Object)jsonNode);
        LOGGER.info("Update Archival Unit Profile EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        return this.adminExternalClient.updateProfile(vitamContext, id, jsonNode);
    }

    public RequestResponse<?> create(VitamContext vitamContext, ProfileModel newArchivalProfile) throws InvalidParseOperationException, AccessExternalClientException, VitamClientException, IOException, JAXBException {
        LOGGER.info("Create Archival Profile EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        ArrayList<ProfileModel> profileModelNewList = new ArrayList<ProfileModel>();
        profileModelNewList.add(newArchivalProfile);
        return this.importArchivalProfiles(vitamContext, profileModelNewList);
    }

    public RequestResponse<?> importArchivalProfiles(VitamContext vitamContext, List<ProfileModel> archivalProfileModels) throws InvalidParseOperationException, AccessExternalClientException, IOException, JAXBException {
        try (ByteArrayInputStream byteArrayInputStream = this.serializeArchivalProfiles(archivalProfileModels);){
            RequestResponse requestResponse = this.adminExternalClient.createProfiles(vitamContext, (InputStream)byteArrayInputStream);
            return requestResponse;
        }
    }

    private ByteArrayInputStream serializeArchivalProfiles(List<ProfileModel> profileModels) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = (JsonNode)mapper.convertValue(profileModels, JsonNode.class);
        LOGGER.debug("The json for creation profile, sent to Vitam {}", (Object)node);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            mapper.writeValue((OutputStream)byteArrayOutputStream, (Object)node);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return byteArrayInputStream;
        }
    }

    public RequestResponse<?> importProfileByFile(VitamContext vitamContext, String fileName, MultipartFile file) throws InvalidParseOperationException, AccessExternalClientException, VitamClientException, IOException {
        LOGGER.debug("Import profile by file {}", (Object)fileName);
        return this.adminExternalClient.createProfiles(vitamContext, file.getInputStream());
    }
}

