/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientServerException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.ProbativeValueRequest;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

public class OperationService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(OperationService.class);
    private final AdminExternalClient adminExternalClient;

    @Autowired
    public OperationService(AdminExternalClient adminExternalClient) {
        this.adminExternalClient = adminExternalClient;
    }

    public Response exportTraceability(VitamContext context, String id) throws VitamClientException, AccessExternalClientServerException {
        LOGGER.info("Export Tracability EvIdAppSession : {} ", (Object)context.getApplicationSessionId());
        return this.adminExternalClient.downloadTraceabilityOperationFile(context, id);
    }

    public Response exportAudit(VitamContext context, String id) throws VitamClientException {
        LOGGER.info("Export Audit EvIdAppSession : {} ", (Object)context.getApplicationSessionId());
        return this.adminExternalClient.downloadBatchReport(context, id);
    }

    public void runAudit(VitamContext context, JsonNode jsonNode) throws AccessExternalClientServerException {
        LOGGER.debug("run audit {}", (Object)jsonNode);
        LOGGER.info("run audit EvIdAppSession : {} ", (Object)context.getApplicationSessionId());
        RequestResponse r = this.adminExternalClient.launchAudit(context, jsonNode);
        LOGGER.debug(r.toString());
    }

    public void lauchEvidenceAudit(VitamContext context, JsonNode jsonNode) throws VitamClientException {
        LOGGER.debug("run evidenceAudit {}", (Object)jsonNode);
        LOGGER.info("run Evidence Audit EvIdAppSession : {} ", (Object)context.getApplicationSessionId());
        RequestResponse r = this.adminExternalClient.evidenceAudit(context, jsonNode);
        LOGGER.debug(r.toString());
    }

    public void launchRectificationAudit(VitamContext context, String evidenceAuditIdentifier) throws VitamClientException {
        LOGGER.debug("Run rectificationAudit {}", (Object)evidenceAuditIdentifier);
        RequestResponse r = this.adminExternalClient.rectificationAudit(context, evidenceAuditIdentifier);
        LOGGER.debug(r.toString());
    }

    public void runProbativeValue(VitamContext context, ProbativeValueRequest request) throws VitamClientException {
        LOGGER.info("run Probative Value EvIdAppSession : {} ", (Object)context.getApplicationSessionId());
        this.adminExternalClient.exportProbativeValue(context, request);
    }
}

