/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.AccessionRegisterSummaryModel;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AccessionRegisterService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(AccessionRegisterService.class);
    private final AdminExternalClient adminExternalClient;

    @Autowired
    public AccessionRegisterService(AdminExternalClient adminExternalClient) {
        this.adminExternalClient = adminExternalClient;
    }

    public RequestResponse<AccessionRegisterSummaryModel> findAccessionRegisterSummary(VitamContext context) throws VitamClientException {
        LOGGER.debug("findAccessionRegisterSymbolic");
        LOGGER.info("Accession Register EvIdAppSession : {} ", (Object)context.getApplicationSessionId());
        return this.adminExternalClient.findAccessionRegister(context, (JsonNode)new Select().getFinalSelect());
    }

    public RequestResponse<AccessionRegisterSummaryModel> findAccessionRegisterSummaryByQuery(VitamContext context, JsonNode query) throws VitamClientException {
        LOGGER.debug("findAccessionRegisterSummary by query projections");
        LOGGER.info("Accession Register Summary by projection query on wanted fields stats : {} ", (Object)context.getApplicationSessionId());
        return this.adminExternalClient.findAccessionRegister(context, query);
    }
}

