/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.model.AuditOptions;
import fr.gouv.vitam.common.model.ProbativeValueRequest;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.referential.common.dto.LogbookOperationDto;
import fr.gouv.vitamui.referential.common.dto.ReportType;
import fr.gouv.vitamui.referential.external.client.OperationExternalRestClient;
import fr.gouv.vitamui.ui.commons.service.AbstractPaginateService;
import fr.gouv.vitamui.ui.commons.service.CommonService;
import java.util.Collection;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class OperationService
extends AbstractPaginateService<LogbookOperationDto> {
    static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(OperationService.class);
    private OperationExternalRestClient client;
    private CommonService commonService;

    @Autowired
    public OperationService(CommonService commonService, OperationExternalRestClient client) {
        this.commonService = commonService;
        this.client = client;
    }

    public PaginatedValuesDto<LogbookOperationDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction, ExternalHttpContext context) {
        return super.getAllPaginated(page, size, criteria, orderBy, direction, context);
    }

    protected Integer beforePaginate(Integer page, Integer size) {
        return this.commonService.checkPagination(page.intValue(), size.intValue());
    }

    public BasePaginatingAndSortingRestClient<LogbookOperationDto, ExternalHttpContext> getClient() {
        return this.client;
    }

    public Collection<LogbookOperationDto> getAll(ExternalHttpContext context, Optional<String> criteria) {
        return this.client.getAll((AbstractHttpContext)context, criteria);
    }

    public LogbookOperationsResponseDto checkTraceabilityOperation(ExternalHttpContext context, String operationId) {
        JsonNode body = this.client.checkTraceabilityOperation(context, operationId);
        try {
            return (LogbookOperationsResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    public boolean runAudit(ExternalHttpContext context, AuditOptions auditOptions) {
        return this.client.runAudit(context, auditOptions);
    }

    public boolean runProbativeValue(ExternalHttpContext context, ProbativeValueRequest probativeValueOptions) {
        return this.client.runProbativeValue(context, probativeValueOptions);
    }

    public ResponseEntity<Resource> export(ExternalHttpContext context, String id, ReportType type) {
        return this.client.export(context, id, type);
    }

    public ResponseEntity<Resource> exportProbativeValue(ExternalHttpContext context, String id) {
        return this.client.exportProbativeValue(context, id);
    }
}

