/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.service;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import fr.gouv.vitamui.referential.common.dto.OntologyDto;
import fr.gouv.vitamui.referential.external.client.OntologyExternalRestClient;
import fr.gouv.vitamui.referential.external.client.OntologyExternalWebClient;
import fr.gouv.vitamui.ui.commons.service.AbstractPaginateService;
import fr.gouv.vitamui.ui.commons.service.CommonService;
import java.util.Collection;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class OntologyService
extends AbstractPaginateService<OntologyDto> {
    static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(OntologyService.class);
    private OntologyExternalRestClient ontologyExternalRestClient;
    private OntologyExternalWebClient webClient;
    private CommonService commonService;

    @Autowired
    public OntologyService(CommonService commonService, OntologyExternalRestClient client, OntologyExternalWebClient webClient) {
        this.commonService = commonService;
        this.ontologyExternalRestClient = client;
        this.webClient = webClient;
    }

    public PaginatedValuesDto<OntologyDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction, ExternalHttpContext context) {
        return super.getAllPaginated(page, size, criteria, orderBy, direction, context);
    }

    protected Integer beforePaginate(Integer page, Integer size) {
        return this.commonService.checkPagination(page.intValue(), size.intValue());
    }

    public BasePaginatingAndSortingRestClient<OntologyDto, ExternalHttpContext> getClient() {
        return this.ontologyExternalRestClient;
    }

    public Collection<OntologyDto> getAll(ExternalHttpContext context, Optional<String> criteria) {
        return this.ontologyExternalRestClient.getAll((AbstractHttpContext)context, criteria);
    }

    public boolean check(ExternalHttpContext context, OntologyDto accessContractDto) {
        return this.ontologyExternalRestClient.check(context, accessContractDto);
    }

    public void delete(ExternalHttpContext context, String id) {
        this.ontologyExternalRestClient.delete((AbstractHttpContext)context, id);
    }

    public ResponseEntity<Resource> export(ExternalHttpContext context) {
        return this.ontologyExternalRestClient.export(context);
    }

    public JsonNode importOntologies(ExternalHttpContext context, MultipartFile file) {
        return this.webClient.importOntologies(context, file);
    }
}

