/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.service;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import fr.gouv.vitamui.referential.common.dto.FileFormatDto;
import fr.gouv.vitamui.referential.external.client.FileFormatExternalRestClient;
import fr.gouv.vitamui.referential.external.client.FileFormatExternalWebClient;
import fr.gouv.vitamui.ui.commons.service.AbstractPaginateService;
import fr.gouv.vitamui.ui.commons.service.CommonService;
import java.util.Collection;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileFormatService
extends AbstractPaginateService<FileFormatDto> {
    static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(FileFormatService.class);
    private FileFormatExternalRestClient client;
    private FileFormatExternalWebClient webClient;
    private CommonService commonService;

    @Autowired
    public FileFormatService(CommonService commonService, FileFormatExternalRestClient client, FileFormatExternalWebClient webClient) {
        this.commonService = commonService;
        this.client = client;
        this.webClient = webClient;
    }

    public PaginatedValuesDto<FileFormatDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction, ExternalHttpContext context) {
        return super.getAllPaginated(page, size, criteria, orderBy, direction, context);
    }

    protected Integer beforePaginate(Integer page, Integer size) {
        return this.commonService.checkPagination(page.intValue(), size.intValue());
    }

    public BasePaginatingAndSortingRestClient<FileFormatDto, ExternalHttpContext> getClient() {
        return this.client;
    }

    public Collection<FileFormatDto> getAll(ExternalHttpContext context, Optional<String> criteria) {
        return this.client.getAll((AbstractHttpContext)context, criteria);
    }

    public boolean check(ExternalHttpContext context, FileFormatDto fileformatDto) {
        return this.client.check(context, fileformatDto);
    }

    public void delete(ExternalHttpContext context, String id) {
        this.client.delete((AbstractHttpContext)context, id);
    }

    public ResponseEntity<Resource> export(ExternalHttpContext context) {
        return this.client.export(context);
    }

    public JsonNode importFileFormats(ExternalHttpContext context, MultipartFile file) {
        return this.webClient.importFileFormats(context, file);
    }
}

