/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.service;

import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import fr.gouv.vitamui.referential.common.dto.AccessContractDto;
import fr.gouv.vitamui.referential.external.client.AccessContractExternalRestClient;
import fr.gouv.vitamui.ui.commons.service.AbstractPaginateService;
import fr.gouv.vitamui.ui.commons.service.CommonService;
import java.util.Collection;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccessContractService
extends AbstractPaginateService<AccessContractDto> {
    static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(AccessContractService.class);
    private AccessContractExternalRestClient client;
    private CommonService commonService;

    @Autowired
    public AccessContractService(CommonService commonService, AccessContractExternalRestClient client) {
        this.commonService = commonService;
        this.client = client;
    }

    public PaginatedValuesDto<AccessContractDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction, ExternalHttpContext context) {
        return super.getAllPaginated(page, size, criteria, orderBy, direction, context);
    }

    public AccessContractDto create(ExternalHttpContext context, AccessContractDto accessContractDto) {
        super.beforeCreate((IdDto)accessContractDto);
        return (AccessContractDto)this.client.create((AbstractHttpContext)context, (IdDto)accessContractDto);
    }

    protected Integer beforePaginate(Integer page, Integer size) {
        return this.commonService.checkPagination(page.intValue(), size.intValue());
    }

    public BasePaginatingAndSortingRestClient<AccessContractDto, ExternalHttpContext> getClient() {
        return this.client;
    }

    public Collection<AccessContractDto> getAll(ExternalHttpContext context, Optional<String> criteria) {
        return this.client.getAll((AbstractHttpContext)context, criteria);
    }

    public boolean check(ExternalHttpContext context, AccessContractDto accessContractDto) {
        return this.client.check(context, accessContractDto);
    }
}

