/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.AbstractUiRestController;
import fr.gouv.vitamui.referential.common.dto.ProfileDto;
import fr.gouv.vitamui.referential.service.ProfileService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"profile"})
@RestController
@RequestMapping(value={"${ui-referential.prefix}/profile"})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ProfileController
extends AbstractUiRestController {
    protected final ProfileService service;
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ProfileController.class);

    @Autowired
    public ProfileController(ProfileService service) {
        this.service = service;
    }

    @ApiOperation(value="Get entity")
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    public Collection<ProfileDto> getAll(Optional<String> criteria) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("Get all with criteria={}", criteria);
        return this.service.getAll(this.buildUiHttpContext(), criteria);
    }
}

